/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.lookup;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.AbstractDataSource;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.util.Assert;

public abstract class AbstractRoutingDataSource
extends AbstractDataSource
implements InitializingBean {
    private Map targetDataSources;
    private Object defaultTargetDataSource;
    private DataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
    private Map resolvedDataSources;
    private DataSource resolvedDefaultDataSource;

    public void setTargetDataSources(Map map) {
        this.targetDataSources = map;
    }

    public void setDefaultTargetDataSource(Object object) {
        this.defaultTargetDataSource = object;
    }

    public void setDataSourceLookup(DataSourceLookup dataSourceLookup) {
        this.dataSourceLookup = dataSourceLookup != null ? dataSourceLookup : new JndiDataSourceLookup();
    }

    public void afterPropertiesSet() {
        if (this.targetDataSources == null) {
            throw new IllegalArgumentException("targetDataSources is required");
        }
        this.resolvedDataSources = new HashMap(this.targetDataSources.size());
        Iterator iterator = this.targetDataSources.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object object = this.resolveSpecifiedLookupKey(entry.getKey());
            DataSource dataSource = this.resolveSpecifiedDataSource(entry.getValue());
            this.resolvedDataSources.put(object, dataSource);
        }
        if (this.defaultTargetDataSource != null) {
            this.resolvedDefaultDataSource = this.resolveSpecifiedDataSource(this.defaultTargetDataSource);
        }
    }

    protected DataSource resolveSpecifiedDataSource(Object object) throws IllegalArgumentException {
        if (object instanceof DataSource) {
            return (DataSource)object;
        }
        if (object instanceof String) {
            return this.dataSourceLookup.getDataSource((String)object);
        }
        throw new IllegalArgumentException("Illegal data source value - only [javax.sql.DataSource] and String supported: " + object);
    }

    public Connection getConnection() throws SQLException {
        return this.determineTargetDataSource().getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.determineTargetDataSource().getConnection(string, string2);
    }

    protected DataSource determineTargetDataSource() {
        Assert.notNull((Object)this.resolvedDataSources, (String)"DataSource router not initialized");
        Object object = this.determineCurrentLookupKey();
        DataSource dataSource = (DataSource)this.resolvedDataSources.get(object);
        if (dataSource == null) {
            dataSource = this.resolvedDefaultDataSource;
        }
        if (dataSource == null) {
            throw new IllegalStateException("Cannot determine target DataSource for lookup key [" + object + "]");
        }
        return dataSource;
    }

    protected Object resolveSpecifiedLookupKey(Object object) {
        return object;
    }

    protected abstract Object determineCurrentLookupKey();
}

