/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.IsolationLevelDataSourceAdapter;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class WebSphereDataSourceAdapter
extends IsolationLevelDataSourceAdapter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class wsDataSourceClass;
    private Method newJdbcConnSpecMethod;
    private Method wsDataSourceGetConnectionMethod;
    private Method setTransactionIsolationMethod;
    private Method setReadOnlyMethod;
    private Method setUserNameMethod;
    private Method setPasswordMethod;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public WebSphereDataSourceAdapter() {
        try {
            this.wsDataSourceClass = this.getClass().getClassLoader().loadClass("com.ibm.websphere.rsadapter.WSDataSource");
            Class<?> clazz = this.getClass().getClassLoader().loadClass("com.ibm.websphere.rsadapter.JDBCConnectionSpec");
            Class<?> clazz2 = this.getClass().getClassLoader().loadClass("com.ibm.websphere.rsadapter.WSRRAFactory");
            this.newJdbcConnSpecMethod = clazz2.getMethod("createJDBCConnectionSpec", null);
            this.wsDataSourceGetConnectionMethod = this.wsDataSourceClass.getMethod("getConnection", clazz);
            this.setTransactionIsolationMethod = clazz.getMethod("setTransactionIsolation", Integer.TYPE);
            this.setReadOnlyMethod = clazz.getMethod("setReadOnly", class$java$lang$Boolean == null ? (class$java$lang$Boolean = WebSphereDataSourceAdapter.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            this.setUserNameMethod = clazz.getMethod("setUserName", class$java$lang$String == null ? (class$java$lang$String = WebSphereDataSourceAdapter.class$("java.lang.String")) : class$java$lang$String);
            this.setPasswordMethod = clazz.getMethod("setPassword", class$java$lang$String == null ? (class$java$lang$String = WebSphereDataSourceAdapter.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not initialize WebSphereDataSourceAdapter because WebSphere API classes are not available: " + exception);
        }
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (!this.wsDataSourceClass.isInstance(this.getTargetDataSource())) {
            throw new IllegalStateException("Specified 'targetDataSource' is not a WebSphere WSDataSource: " + this.getTargetDataSource());
        }
    }

    protected Connection doGetConnection(String string, String string2) throws SQLException {
        Object object = this.createConnectionSpec(this.getCurrentIsolationLevel(), this.getCurrentReadOnlyFlag(), string, string2);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Obtaining JDBC Connection from WebSphere DataSource [" + this.getTargetDataSource() + "], using ConnectionSpec [" + object + "]"));
        }
        return (Connection)ReflectionUtils.invokeMethod((Method)this.wsDataSourceGetConnectionMethod, (Object)this.getTargetDataSource(), (Object[])new Object[]{object});
    }

    protected Object createConnectionSpec(Integer n, Boolean bl, String string, String string2) throws SQLException {
        Object object = ReflectionUtils.invokeMethod((Method)this.newJdbcConnSpecMethod, null);
        if (n != null) {
            ReflectionUtils.invokeMethod((Method)this.setTransactionIsolationMethod, (Object)object, (Object[])new Object[]{n});
        }
        if (bl != null) {
            ReflectionUtils.invokeMethod((Method)this.setReadOnlyMethod, (Object)object, (Object[])new Object[]{bl});
        }
        if (StringUtils.hasLength((String)string)) {
            ReflectionUtils.invokeMethod((Method)this.setUserNameMethod, (Object)object, (Object[])new Object[]{string});
            ReflectionUtils.invokeMethod((Method)this.setPasswordMethod, (Object)object, (Object[])new Object[]{string2});
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

