/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class UserCredentialsDataSourceAdapter
extends DelegatingDataSource {
    private String username;
    private String password;
    private final ThreadLocal threadBoundCredentials = new ThreadLocal();

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setCredentialsForCurrentThread(String string, String string2) {
        this.threadBoundCredentials.set(new String[]{string, string2});
    }

    public void removeCredentialsFromCurrentThread() {
        this.threadBoundCredentials.set(null);
    }

    public Connection getConnection() throws SQLException {
        String[] stringArray = (String[])this.threadBoundCredentials.get();
        if (stringArray != null) {
            return this.doGetConnection(stringArray[0], stringArray[1]);
        }
        return this.doGetConnection(this.username, this.password);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.doGetConnection(string, string2);
    }

    protected Connection doGetConnection(String string, String string2) throws SQLException {
        Assert.state((this.getTargetDataSource() != null ? 1 : 0) != 0, (String)"'targetDataSource' is required");
        if (StringUtils.hasLength((String)string)) {
            return this.getTargetDataSource().getConnection(string, string2);
        }
        return this.getTargetDataSource().getConnection();
    }
}

