/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.util.Assert;

public class TransactionAwareDataSourceProxy
extends DelegatingDataSource {
    static /* synthetic */ Class class$org$springframework$jdbc$datasource$ConnectionProxy;

    public TransactionAwareDataSourceProxy() {
    }

    public TransactionAwareDataSourceProxy(DataSource dataSource) {
        super(dataSource);
    }

    public Connection getConnection() throws SQLException {
        Assert.state((this.getTargetDataSource() != null ? 1 : 0) != 0, (String)"'targetDataSource' is required");
        Connection connection = DataSourceUtils.doGetConnection(this.getTargetDataSource());
        return this.getTransactionAwareConnectionProxy(connection, this.getTargetDataSource());
    }

    protected Connection getTransactionAwareConnectionProxy(Connection connection, DataSource dataSource) {
        return (Connection)Proxy.newProxyInstance((class$org$springframework$jdbc$datasource$ConnectionProxy == null ? (class$org$springframework$jdbc$datasource$ConnectionProxy = TransactionAwareDataSourceProxy.class$("org.springframework.jdbc.datasource.ConnectionProxy")) : class$org$springframework$jdbc$datasource$ConnectionProxy).getClassLoader(), new Class[]{class$org$springframework$jdbc$datasource$ConnectionProxy == null ? (class$org$springframework$jdbc$datasource$ConnectionProxy = TransactionAwareDataSourceProxy.class$("org.springframework.jdbc.datasource.ConnectionProxy")) : class$org$springframework$jdbc$datasource$ConnectionProxy}, (InvocationHandler)new TransactionAwareInvocationHandler(connection, dataSource));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private final Connection target;
        private final DataSource dataSource;

        public TransactionAwareInvocationHandler(Connection connection, DataSource dataSource) {
            this.target = connection;
            this.dataSource = dataSource;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            if (method.getName().equals("equals")) {
                return object == objectArray[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("close")) {
                DataSourceUtils.doReleaseConnection(this.target, this.dataSource);
                return null;
            }
            try {
                Object object2 = method.invoke((Object)this.target, objectArray);
                if (object2 instanceof Statement) {
                    DataSourceUtils.applyTransactionTimeout((Statement)object2, this.dataSource);
                }
                return object2;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
    }
}

