/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jdbc.datasource.SmartDataSource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class SingleConnectionDataSource
extends DriverManagerDataSource
implements SmartDataSource,
DisposableBean {
    private boolean suppressClose;
    private Boolean autoCommit;
    private Connection target;
    private Connection connection;
    private final Object connectionMonitor = new Object();
    static /* synthetic */ Class class$org$springframework$jdbc$datasource$ConnectionProxy;

    public SingleConnectionDataSource() {
    }

    public SingleConnectionDataSource(String string, String string2, String string3, String string4, boolean bl) throws CannotGetJdbcConnectionException {
        super(string, string2, string3, string4);
        this.suppressClose = bl;
    }

    public SingleConnectionDataSource(String string, String string2, String string3, boolean bl) throws CannotGetJdbcConnectionException {
        super(string, string2, string3);
        this.suppressClose = bl;
    }

    public SingleConnectionDataSource(String string, boolean bl) throws CannotGetJdbcConnectionException {
        super(string);
        this.suppressClose = bl;
    }

    public SingleConnectionDataSource(Connection connection, boolean bl) {
        Assert.notNull((Object)connection, (String)"Connection must not be null");
        this.target = connection;
        this.suppressClose = bl;
        this.connection = bl ? this.getCloseSuppressingConnectionProxy(connection) : connection;
    }

    public void setSuppressClose(boolean bl) {
        this.suppressClose = bl;
    }

    protected boolean isSuppressClose() {
        return this.suppressClose;
    }

    public void setAutoCommit(boolean bl) {
        this.autoCommit = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Boolean getAutoCommitValue() {
        return this.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection == null) {
                this.initConnection();
            }
            if (this.connection.isClosed()) {
                throw new SQLException("Connection was closed in SingleConnectionDataSource. Check that user code checks shouldClose() before closing Connections, or set 'suppressClose' to 'true'");
            }
            return this.connection;
        }
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (ObjectUtils.nullSafeEquals((Object)string, (Object)this.getUsername()) && ObjectUtils.nullSafeEquals((Object)string2, (Object)this.getPassword())) {
            return this.getConnection();
        }
        throw new SQLException("SingleConnectionDataSource does not support custom username and password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldClose(Connection connection) {
        Object object = this.connectionMonitor;
        synchronized (object) {
            return connection != this.connection && connection != this.target;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConnection() throws SQLException {
        if (this.getUrl() == null) {
            throw new IllegalStateException("'url' property is required for lazily initializing a Connection");
        }
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.closeConnection();
            this.target = this.getConnectionFromDriverManager();
            this.prepareConnection(this.target);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Established shared JDBC Connection: " + this.target));
            }
            this.connection = this.isSuppressClose() ? this.getCloseSuppressingConnectionProxy(this.target) : this.target;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.closeConnection();
            this.target = null;
            this.connection = null;
        }
    }

    protected void prepareConnection(Connection connection) throws SQLException {
        Boolean bl = this.getAutoCommitValue();
        if (bl != null && connection.getAutoCommit() != bl.booleanValue()) {
            connection.setAutoCommit(bl);
        }
    }

    private void closeConnection() {
        if (this.target != null) {
            try {
                this.target.close();
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)"Could not close shared JDBC Connection", throwable);
            }
        }
    }

    protected Connection getCloseSuppressingConnectionProxy(Connection connection) {
        return (Connection)Proxy.newProxyInstance((class$org$springframework$jdbc$datasource$ConnectionProxy == null ? (class$org$springframework$jdbc$datasource$ConnectionProxy = SingleConnectionDataSource.class$("org.springframework.jdbc.datasource.ConnectionProxy")) : class$org$springframework$jdbc$datasource$ConnectionProxy).getClassLoader(), new Class[]{class$org$springframework$jdbc$datasource$ConnectionProxy == null ? (class$org$springframework$jdbc$datasource$ConnectionProxy = SingleConnectionDataSource.class$("org.springframework.jdbc.datasource.ConnectionProxy")) : class$org$springframework$jdbc$datasource$ConnectionProxy}, (InvocationHandler)new CloseSuppressingInvocationHandler(connection));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public CloseSuppressingInvocationHandler(Connection connection) {
            this.target = connection;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            if (method.getName().equals("equals")) {
                return object == objectArray[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                return method.invoke((Object)this.target, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
    }
}

