/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Savepoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.SavepointManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.TransactionUsageException;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.util.ClassUtils;

public abstract class JdbcTransactionObjectSupport
implements SavepointManager,
SmartTransactionObject {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jdbc$datasource$JdbcTransactionObjectSupport == null ? (class$org$springframework$jdbc$datasource$JdbcTransactionObjectSupport = JdbcTransactionObjectSupport.class$("org.springframework.jdbc.datasource.JdbcTransactionObjectSupport")) : class$org$springframework$jdbc$datasource$JdbcTransactionObjectSupport));
    private static boolean savepointClassAvailable = ClassUtils.isPresent((String)"java.sql.Savepoint", (ClassLoader)(class$org$springframework$jdbc$datasource$JdbcTransactionObjectSupport == null ? (class$org$springframework$jdbc$datasource$JdbcTransactionObjectSupport = JdbcTransactionObjectSupport.class$("org.springframework.jdbc.datasource.JdbcTransactionObjectSupport")) : class$org$springframework$jdbc$datasource$JdbcTransactionObjectSupport).getClassLoader());
    private ConnectionHolder connectionHolder;
    private Integer previousIsolationLevel;
    private boolean savepointAllowed;
    static /* synthetic */ Class class$org$springframework$jdbc$datasource$JdbcTransactionObjectSupport;

    public void setConnectionHolder(ConnectionHolder connectionHolder) {
        this.connectionHolder = connectionHolder;
    }

    public ConnectionHolder getConnectionHolder() {
        return this.connectionHolder;
    }

    public boolean hasConnectionHolder() {
        return this.connectionHolder != null;
    }

    public void setPreviousIsolationLevel(Integer n) {
        this.previousIsolationLevel = n;
    }

    public Integer getPreviousIsolationLevel() {
        return this.previousIsolationLevel;
    }

    public void setSavepointAllowed(boolean bl) {
        this.savepointAllowed = bl;
    }

    public boolean isSavepointAllowed() {
        return this.savepointAllowed;
    }

    public Object createSavepoint() throws TransactionException {
        if (!savepointClassAvailable) {
            throw new NestedTransactionNotSupportedException("Cannot create a nested JDBC transaction because you are not running on JDK 1.4 or higher");
        }
        ConnectionHolder connectionHolder = this.getConnectionHolderForSavepoint();
        try {
            if (!connectionHolder.supportsSavepoints()) {
                throw new NestedTransactionNotSupportedException("Cannot create a nested transaction because savepoints are not supported by your JDBC driver");
            }
        }
        catch (Throwable throwable) {
            throw new NestedTransactionNotSupportedException("Cannot create a nested transaction because your JDBC driver is not a JDBC 3.0 driver", throwable);
        }
        try {
            return connectionHolder.createSavepoint();
        }
        catch (Throwable throwable) {
            throw new CannotCreateTransactionException("Could not create JDBC savepoint", throwable);
        }
    }

    public void rollbackToSavepoint(Object object) throws TransactionException {
        try {
            this.getConnectionHolderForSavepoint().getConnection().rollback((Savepoint)object);
        }
        catch (Throwable throwable) {
            throw new TransactionSystemException("Could not roll back to JDBC savepoint", throwable);
        }
    }

    public void releaseSavepoint(Object object) throws TransactionException {
        try {
            this.getConnectionHolderForSavepoint().getConnection().releaseSavepoint((Savepoint)object);
        }
        catch (Throwable throwable) {
            logger.debug((Object)"Could not explicitly release JDBC savepoint", throwable);
        }
    }

    protected ConnectionHolder getConnectionHolderForSavepoint() throws TransactionException {
        if (!this.isSavepointAllowed()) {
            throw new NestedTransactionNotSupportedException("Transaction manager does not allow nested transactions");
        }
        if (!this.hasConnectionHolder()) {
            throw new TransactionUsageException("Cannot create nested transaction if not exposing a JDBC transaction");
        }
        return this.getConnectionHolder();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

