/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.core.Constants;
import org.springframework.jdbc.datasource.UserCredentialsDataSourceAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class IsolationLevelDataSourceAdapter
extends UserCredentialsDataSourceAdapter {
    private static final Constants constants = new Constants(class$org$springframework$transaction$TransactionDefinition == null ? (class$org$springframework$transaction$TransactionDefinition = IsolationLevelDataSourceAdapter.class$("org.springframework.transaction.TransactionDefinition")) : class$org$springframework$transaction$TransactionDefinition);
    private Integer isolationLevel;
    static /* synthetic */ Class class$org$springframework$transaction$TransactionDefinition;

    public final void setIsolationLevelName(String string) throws IllegalArgumentException {
        if (string == null || !string.startsWith("ISOLATION_")) {
            throw new IllegalArgumentException("Only isolation constants allowed");
        }
        this.setIsolationLevel(constants.asNumber(string).intValue());
    }

    public void setIsolationLevel(int n) {
        if (!constants.getValues("ISOLATION_").contains(new Integer(n))) {
            throw new IllegalArgumentException("Only values of isolation constants allowed");
        }
        this.isolationLevel = n != -1 ? new Integer(n) : null;
    }

    protected Integer getIsolationLevel() {
        return this.isolationLevel;
    }

    protected Connection doGetConnection(String string, String string2) throws SQLException {
        Integer n;
        Connection connection = super.doGetConnection(string, string2);
        Boolean bl = this.getCurrentReadOnlyFlag();
        if (bl != null) {
            connection.setReadOnly(bl);
        }
        if ((n = this.getCurrentIsolationLevel()) != null) {
            connection.setTransactionIsolation(n);
        }
        return connection;
    }

    protected Integer getCurrentIsolationLevel() {
        Integer n = TransactionSynchronizationManager.getCurrentTransactionIsolationLevel();
        if (n == null) {
            n = this.getIsolationLevel();
        }
        return n;
    }

    protected Boolean getCurrentReadOnlyFlag() {
        boolean bl = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
        return bl ? Boolean.TRUE : null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

