/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.AbstractDataSource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DriverManagerDataSource
extends AbstractDataSource {
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private Properties connectionProperties;

    public DriverManagerDataSource() {
    }

    public DriverManagerDataSource(String string, String string2, String string3, String string4) throws CannotGetJdbcConnectionException {
        this.setDriverClassName(string);
        this.setUrl(string2);
        this.setUsername(string3);
        this.setPassword(string4);
    }

    public DriverManagerDataSource(String string, String string2, String string3) throws CannotGetJdbcConnectionException {
        this.setUrl(string);
        this.setUsername(string2);
        this.setPassword(string3);
    }

    public DriverManagerDataSource(String string) throws CannotGetJdbcConnectionException {
        this.setUrl(string);
    }

    public void setDriverClassName(String string) throws CannotGetJdbcConnectionException {
        if (!StringUtils.hasText((String)string)) {
            throw new IllegalArgumentException("driverClassName must not be empty");
        }
        this.driverClassName = string.trim();
        try {
            Class.forName(this.driverClassName, true, ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CannotGetJdbcConnectionException("Could not load JDBC driver class [" + this.driverClassName + "]", classNotFoundException);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Loaded JDBC driver: " + this.driverClassName));
        }
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setUrl(String string) {
        if (!StringUtils.hasText((String)string)) {
            throw new IllegalArgumentException("url must not be empty");
        }
        this.url = string.trim();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setConnectionProperties(Properties properties) {
        this.connectionProperties = properties;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnectionFromDriverManager();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.getConnectionFromDriverManager(string, string2);
    }

    protected Connection getConnectionFromDriverManager() throws SQLException {
        return this.getConnectionFromDriverManager(this.getUsername(), this.getPassword());
    }

    protected Connection getConnectionFromDriverManager(String string, String string2) throws SQLException {
        Properties properties = new Properties(this.getConnectionProperties());
        if (string != null) {
            properties.setProperty("user", string);
        }
        if (string2 != null) {
            properties.setProperty("password", string2);
        }
        return this.getConnectionFromDriverManager(this.getUrl(), properties);
    }

    protected Connection getConnectionFromDriverManager(String string, Properties properties) throws SQLException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new JDBC Connection to [" + string + "]"));
        }
        return DriverManager.getConnection(string, properties);
    }
}

