/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DelegatingDataSource
implements DataSource,
InitializingBean {
    private DataSource targetDataSource;

    public DelegatingDataSource() {
    }

    public DelegatingDataSource(DataSource dataSource) {
        this.setTargetDataSource(dataSource);
    }

    public final void setTargetDataSource(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"'targetDataSource' must not be null");
        this.targetDataSource = dataSource;
    }

    public DataSource getTargetDataSource() {
        return this.targetDataSource;
    }

    public void afterPropertiesSet() {
        if (this.getTargetDataSource() == null) {
            throw new IllegalArgumentException("Property 'targetDataSource' is required");
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getTargetDataSource().getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.getTargetDataSource().getConnection(string, string2);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getTargetDataSource().getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.getTargetDataSource().setLogWriter(printWriter);
    }

    public int getLoginTimeout() throws SQLException {
        return this.getTargetDataSource().getLoginTimeout();
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.getTargetDataSource().setLoginTimeout(n);
    }
}

