/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DataSourceTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    private DataSource dataSource;

    public DataSourceTransactionManager() {
        this.setNestedTransactionAllowed(true);
    }

    public DataSourceTransactionManager(DataSource dataSource) {
        this();
        this.setDataSource(dataSource);
        this.afterPropertiesSet();
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void afterPropertiesSet() {
        if (this.getDataSource() == null) {
            throw new IllegalArgumentException("Property 'dataSource' is required");
        }
    }

    public Object getResourceFactory() {
        return this.getDataSource();
    }

    protected Object doGetTransaction() {
        DataSourceTransactionObject dataSourceTransactionObject = new DataSourceTransactionObject();
        dataSourceTransactionObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        ConnectionHolder connectionHolder = (ConnectionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.dataSource));
        dataSourceTransactionObject.setConnectionHolder(connectionHolder, false);
        return dataSourceTransactionObject;
    }

    protected boolean isExistingTransaction(Object object) {
        DataSourceTransactionObject dataSourceTransactionObject = (DataSourceTransactionObject)object;
        return dataSourceTransactionObject.getConnectionHolder() != null && dataSourceTransactionObject.getConnectionHolder().isTransactionActive();
    }

    protected void doBegin(Object object, TransactionDefinition transactionDefinition) {
        DataSourceTransactionObject dataSourceTransactionObject = (DataSourceTransactionObject)object;
        Connection connection = null;
        try {
            Object object2;
            if (dataSourceTransactionObject.getConnectionHolder() == null || dataSourceTransactionObject.getConnectionHolder().isSynchronizedWithTransaction()) {
                object2 = this.dataSource.getConnection();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Acquired Connection [" + object2 + "] for JDBC transaction"));
                }
                dataSourceTransactionObject.setConnectionHolder(new ConnectionHolder((Connection)object2), true);
            }
            dataSourceTransactionObject.getConnectionHolder().setSynchronizedWithTransaction(true);
            connection = dataSourceTransactionObject.getConnectionHolder().getConnection();
            object2 = DataSourceUtils.prepareConnectionForTransaction(connection, transactionDefinition);
            dataSourceTransactionObject.setPreviousIsolationLevel((Integer)object2);
            if (connection.getAutoCommit()) {
                dataSourceTransactionObject.setMustRestoreAutoCommit(true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Switching JDBC Connection [" + connection + "] to manual commit"));
                }
                connection.setAutoCommit(false);
            }
            dataSourceTransactionObject.getConnectionHolder().setTransactionActive(true);
            int n = this.determineTimeout(transactionDefinition);
            if (n != -1) {
                dataSourceTransactionObject.getConnectionHolder().setTimeoutInSeconds(n);
            }
            if (dataSourceTransactionObject.isNewConnectionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.getDataSource(), (Object)((Object)dataSourceTransactionObject.getConnectionHolder()));
            }
        }
        catch (SQLException sQLException) {
            DataSourceUtils.releaseConnection(connection, this.dataSource);
            throw new CannotCreateTransactionException("Could not open JDBC Connection for transaction", (Throwable)sQLException);
        }
    }

    protected Object doSuspend(Object object) {
        DataSourceTransactionObject dataSourceTransactionObject = (DataSourceTransactionObject)object;
        dataSourceTransactionObject.setConnectionHolder(null);
        ConnectionHolder connectionHolder = (ConnectionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.dataSource));
        return connectionHolder;
    }

    protected void doResume(Object object, Object object2) {
        ConnectionHolder connectionHolder = (ConnectionHolder)((Object)object2);
        TransactionSynchronizationManager.bindResource((Object)this.dataSource, (Object)((Object)connectionHolder));
    }

    protected void doCommit(DefaultTransactionStatus defaultTransactionStatus) {
        DataSourceTransactionObject dataSourceTransactionObject = (DataSourceTransactionObject)defaultTransactionStatus.getTransaction();
        Connection connection = dataSourceTransactionObject.getConnectionHolder().getConnection();
        if (defaultTransactionStatus.isDebug()) {
            this.logger.debug((Object)("Committing JDBC transaction on Connection [" + connection + "]"));
        }
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            throw new TransactionSystemException("Could not commit JDBC transaction", (Throwable)sQLException);
        }
    }

    protected void doRollback(DefaultTransactionStatus defaultTransactionStatus) {
        DataSourceTransactionObject dataSourceTransactionObject = (DataSourceTransactionObject)defaultTransactionStatus.getTransaction();
        Connection connection = dataSourceTransactionObject.getConnectionHolder().getConnection();
        if (defaultTransactionStatus.isDebug()) {
            this.logger.debug((Object)("Rolling back JDBC transaction on Connection [" + connection + "]"));
        }
        try {
            connection.rollback();
        }
        catch (SQLException sQLException) {
            throw new TransactionSystemException("Could not roll back JDBC transaction", (Throwable)sQLException);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus defaultTransactionStatus) {
        DataSourceTransactionObject dataSourceTransactionObject = (DataSourceTransactionObject)defaultTransactionStatus.getTransaction();
        if (defaultTransactionStatus.isDebug()) {
            this.logger.debug((Object)("Setting JDBC transaction [" + dataSourceTransactionObject.getConnectionHolder().getConnection() + "] rollback-only"));
        }
        dataSourceTransactionObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object object) {
        DataSourceTransactionObject dataSourceTransactionObject = (DataSourceTransactionObject)object;
        if (dataSourceTransactionObject.isNewConnectionHolder()) {
            TransactionSynchronizationManager.unbindResource((Object)this.dataSource);
        }
        Connection connection = dataSourceTransactionObject.getConnectionHolder().getConnection();
        try {
            if (dataSourceTransactionObject.isMustRestoreAutoCommit()) {
                connection.setAutoCommit(true);
            }
            DataSourceUtils.resetConnectionAfterTransaction(connection, dataSourceTransactionObject.getPreviousIsolationLevel());
        }
        catch (Throwable throwable) {
            this.logger.debug((Object)"Could not reset JDBC Connection after transaction", throwable);
        }
        if (dataSourceTransactionObject.isNewConnectionHolder()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Releasing JDBC Connection [" + connection + "] after transaction"));
            }
            DataSourceUtils.releaseConnection(connection, this.dataSource);
        }
        dataSourceTransactionObject.getConnectionHolder().clear();
    }

    private static class DataSourceTransactionObject
    extends JdbcTransactionObjectSupport {
        private boolean newConnectionHolder;
        private boolean mustRestoreAutoCommit;

        private DataSourceTransactionObject() {
        }

        public void setConnectionHolder(ConnectionHolder connectionHolder, boolean bl) {
            super.setConnectionHolder(connectionHolder);
            this.newConnectionHolder = bl;
        }

        public boolean isNewConnectionHolder() {
            return this.newConnectionHolder;
        }

        public boolean hasTransaction() {
            return this.getConnectionHolder() != null && this.getConnectionHolder().isTransactionActive();
        }

        public void setMustRestoreAutoCommit(boolean bl) {
            this.mustRestoreAutoCommit = bl;
        }

        public boolean isMustRestoreAutoCommit() {
            return this.mustRestoreAutoCommit;
        }

        public void setRollbackOnly() {
            this.getConnectionHolder().setRollbackOnly();
        }

        public boolean isRollbackOnly() {
            return this.getConnectionHolder().isRollbackOnly();
        }
    }
}

