/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.support;

import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.springframework.jdbc.core.DisposableSqlTypeValue;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;

public class SqlLobValue
implements DisposableSqlTypeValue {
    private final Object content;
    private final int length;
    private final LobCreator lobCreator;

    public SqlLobValue(byte[] byArray) {
        this(byArray, (LobHandler)new DefaultLobHandler());
    }

    public SqlLobValue(byte[] byArray, LobHandler lobHandler) {
        this.content = byArray;
        this.length = byArray != null ? byArray.length : 0;
        this.lobCreator = lobHandler.getLobCreator();
    }

    public SqlLobValue(String string) {
        this(string, (LobHandler)new DefaultLobHandler());
    }

    public SqlLobValue(String string, LobHandler lobHandler) {
        this.content = string;
        this.length = string != null ? string.length() : 0;
        this.lobCreator = lobHandler.getLobCreator();
    }

    public SqlLobValue(InputStream inputStream, int n) {
        this(inputStream, n, (LobHandler)new DefaultLobHandler());
    }

    public SqlLobValue(InputStream inputStream, int n, LobHandler lobHandler) {
        this.content = inputStream;
        this.length = n;
        this.lobCreator = lobHandler.getLobCreator();
    }

    public SqlLobValue(Reader reader, int n) {
        this(reader, n, (LobHandler)new DefaultLobHandler());
    }

    public SqlLobValue(Reader reader, int n, LobHandler lobHandler) {
        this.content = reader;
        this.length = n;
        this.lobCreator = lobHandler.getLobCreator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTypeValue(PreparedStatement preparedStatement, int n, int n2, String string) throws SQLException {
        if (n2 == 2004) {
            if (this.content instanceof byte[] || this.content == null) {
                this.lobCreator.setBlobAsBytes(preparedStatement, n, (byte[])this.content);
                return;
            } else if (this.content instanceof String) {
                this.lobCreator.setBlobAsBytes(preparedStatement, n, ((String)this.content).getBytes());
                return;
            } else {
                if (!(this.content instanceof InputStream)) throw new IllegalArgumentException("Content type [" + this.content.getClass().getName() + "] not supported for BLOB columns");
                this.lobCreator.setBlobAsBinaryStream(preparedStatement, n, (InputStream)this.content, this.length);
            }
            return;
        } else {
            if (n2 != 2005) throw new IllegalArgumentException("SqlLobValue only supports SQL types BLOB and CLOB");
            if (this.content instanceof String || this.content == null) {
                this.lobCreator.setClobAsString(preparedStatement, n, (String)this.content);
                return;
            } else if (this.content instanceof InputStream) {
                this.lobCreator.setClobAsAsciiStream(preparedStatement, n, (InputStream)this.content, this.length);
                return;
            } else {
                if (!(this.content instanceof Reader)) throw new IllegalArgumentException("Content type [" + this.content.getClass().getName() + "] not supported for CLOB columns");
                this.lobCreator.setClobAsCharacterStream(preparedStatement, n, (Reader)this.content, this.length);
            }
        }
    }

    public void cleanup() {
        this.lobCreator.close();
    }
}

