/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.support;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.PropertiesBeanDefinitionReader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.util.Assert;

public class JdbcBeanDefinitionReader {
    private final PropertiesBeanDefinitionReader propReader;
    private JdbcTemplate jdbcTemplate;

    public JdbcBeanDefinitionReader(BeanDefinitionRegistry beanDefinitionRegistry) {
        this.propReader = new PropertiesBeanDefinitionReader(beanDefinitionRegistry);
    }

    public JdbcBeanDefinitionReader(PropertiesBeanDefinitionReader propertiesBeanDefinitionReader) {
        Assert.notNull((Object)propertiesBeanDefinitionReader, (String)"Bean definition reader must not be null");
        this.propReader = propertiesBeanDefinitionReader;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate, (String)"JdbcTemplate must not be null");
        this.jdbcTemplate = jdbcTemplate;
    }

    public void loadBeanDefinitions(String string) {
        Assert.notNull((Object)this.jdbcTemplate, (String)"Not fully configured - specify DataSource or JdbcTemplate");
        final Properties properties = new Properties();
        this.jdbcTemplate.query(string, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                properties.setProperty(string + "." + string2, string3);
            }
        });
        this.propReader.registerBeanDefinitions((Map)properties);
    }
}

