/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.simple;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJdbcTemplate
implements SimpleJdbcOperations {
    private final JdbcOperations classicJdbcTemplate;

    public SimpleJdbcTemplate(DataSource dataSource) {
        this.classicJdbcTemplate = new JdbcTemplate(dataSource);
    }

    public SimpleJdbcTemplate(JdbcOperations jdbcOperations) {
        this.classicJdbcTemplate = jdbcOperations;
    }

    @Override
    public JdbcOperations getJdbcOperations() {
        return this.classicJdbcTemplate;
    }

    @Override
    public int queryForInt(String string, Object ... objectArray) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])objectArray) ? this.getJdbcOperations().queryForInt(string) : this.getJdbcOperations().queryForInt(string, objectArray);
    }

    @Override
    public long queryForLong(String string, Object ... objectArray) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])objectArray) ? this.getJdbcOperations().queryForLong(string) : this.getJdbcOperations().queryForLong(string, objectArray);
    }

    @Override
    public <T> T queryForObject(String string, Class<T> clazz, Object ... objectArray) throws DataAccessException {
        return (T)(ObjectUtils.isEmpty((Object[])objectArray) ? this.getJdbcOperations().queryForObject(string, clazz) : this.getJdbcOperations().queryForObject(string, objectArray, clazz));
    }

    @Override
    public <T> T queryForObject(String string, ParameterizedRowMapper<T> parameterizedRowMapper, Object ... objectArray) throws DataAccessException {
        return (T)(ObjectUtils.isEmpty((Object[])objectArray) ? this.getJdbcOperations().queryForObject(string, parameterizedRowMapper) : this.getJdbcOperations().queryForObject(string, objectArray, parameterizedRowMapper));
    }

    @Override
    public <T> List<T> query(String string, ParameterizedRowMapper<T> parameterizedRowMapper, Object ... objectArray) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])objectArray) ? this.getJdbcOperations().query(string, parameterizedRowMapper) : this.getJdbcOperations().query(string, objectArray, parameterizedRowMapper);
    }

    @Override
    public Map<String, Object> queryForMap(String string, Object ... objectArray) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])objectArray) ? this.getJdbcOperations().queryForMap(string) : this.getJdbcOperations().queryForMap(string, objectArray);
    }

    @Override
    public List<Map<String, Object>> queryForList(String string, Object ... objectArray) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])objectArray) ? this.getJdbcOperations().queryForList(string) : this.getJdbcOperations().queryForList(string, objectArray);
    }

    @Override
    public int update(String string, Object ... objectArray) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])objectArray) ? this.getJdbcOperations().update(string) : this.getJdbcOperations().update(string, objectArray);
    }
}

