/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;

public abstract class NamedParameterUtils {
    private static final char[] PARAMETER_SEPARATORS = new char[]{'\"', '\'', ':', '&', ',', ';', '(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^'};

    public static ParsedSql parseSqlStatement(String string) {
        Assert.notNull((Object)string, (String)"SQL must not be null");
        HashSet<String> hashSet = new HashSet<String>();
        ParsedSql parsedSql = new ParsedSql(string);
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 45;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            int n5 = cArray[i];
            if (bl) {
                if (n5 != n) continue;
                bl = false;
                n = 45;
                continue;
            }
            if (n5 == 34 || n5 == 39) {
                bl = true;
                n = n5;
                continue;
            }
            if (n5 == 58 || n5 == 38) {
                int n6;
                for (n6 = i + 1; n6 < cArray.length && !NamedParameterUtils.isParameterSeparator(cArray[n6]); ++n6) {
                }
                if (n6 - i > 1) {
                    String string2 = string.substring(i + 1, n6);
                    if (!hashSet.contains(string2)) {
                        hashSet.add(string2);
                        ++n2;
                    }
                    parsedSql.addNamedParameter(string2, i, n6);
                    ++n4;
                }
                i = n6 - 1;
                continue;
            }
            if (n5 != 63) continue;
            ++n3;
            ++n4;
        }
        parsedSql.setNamedParameterCount(n2);
        parsedSql.setUnnamedParameterCount(n3);
        parsedSql.setTotalParameterCount(n4);
        return parsedSql;
    }

    public static String substituteNamedParameters(ParsedSql parsedSql, SqlParameterSource sqlParameterSource) {
        String string = parsedSql.getOriginalSql();
        StringBuffer stringBuffer = new StringBuffer();
        List list = parsedSql.getParameterNames();
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            int[] nArray = parsedSql.getParameterIndexes(i);
            int n2 = nArray[0];
            int n3 = nArray[1];
            stringBuffer.append(string.substring(n, n2));
            if (sqlParameterSource != null && sqlParameterSource.hasValue(string2)) {
                Object object = sqlParameterSource.getValue(string2);
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    for (int j = 0; j < collection.size(); ++j) {
                        if (j > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append("?");
                    }
                } else {
                    stringBuffer.append("?");
                }
            } else {
                stringBuffer.append("?");
            }
            n = n3;
        }
        stringBuffer.append(string.substring(n, string.length()));
        return stringBuffer.toString();
    }

    public static Object[] buildValueArray(ParsedSql parsedSql, SqlParameterSource sqlParameterSource, List list) {
        Object[] objectArray = new Object[parsedSql.getTotalParameterCount()];
        if (parsedSql.getNamedParameterCount() > 0 && parsedSql.getUnnamedParameterCount() > 0) {
            throw new InvalidDataAccessApiUsageException("You can't mix named and traditional ? placeholders. You have " + parsedSql.getNamedParameterCount() + " named parameter(s) and " + parsedSql.getUnnamedParameterCount() + " traditonal placeholder(s) in [" + parsedSql.getOriginalSql() + "]");
        }
        List list2 = parsedSql.getParameterNames();
        for (int i = 0; i < list2.size(); ++i) {
            String string = (String)list2.get(i);
            try {
                Object object = sqlParameterSource.getValue(string);
                SqlParameter sqlParameter = NamedParameterUtils.findParameter(list, string, i);
                objectArray[i] = sqlParameter != null ? new SqlParameterValue(sqlParameter, object) : object;
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidDataAccessApiUsageException("No value supplied for the SQL parameter '" + string + "': " + illegalArgumentException.getMessage());
            }
        }
        return objectArray;
    }

    private static SqlParameter findParameter(List list, String string, int n) {
        if (list != null) {
            Object object = list.iterator();
            while (object.hasNext()) {
                SqlParameter sqlParameter = (SqlParameter)object.next();
                if (!string.equals(sqlParameter.getName())) continue;
                return sqlParameter;
            }
            if (n < list.size() && ((SqlParameter)(object = (SqlParameter)list.get(n))).getName() == null) {
                return object;
            }
        }
        return null;
    }

    private static boolean isParameterSeparator(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        for (int i = 0; i < PARAMETER_SEPARATORS.length; ++i) {
            if (c != PARAMETER_SEPARATORS[i]) continue;
            return true;
        }
        return false;
    }

    static int[] buildSqlTypeArray(ParsedSql parsedSql, SqlParameterSource sqlParameterSource) {
        int[] nArray = new int[parsedSql.getTotalParameterCount()];
        List list = parsedSql.getParameterNames();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            nArray[i] = sqlParameterSource.getSqlType(string);
        }
        return nArray;
    }

    public static String parseSqlStatementIntoString(String string) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(string);
        return NamedParameterUtils.substituteNamedParameters(parsedSql, null);
    }

    public static String substituteNamedParameters(String string, SqlParameterSource sqlParameterSource) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(string);
        return NamedParameterUtils.substituteNamedParameters(parsedSql, sqlParameterSource);
    }

    public static Object[] buildValueArray(String string, Map map) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(string);
        return NamedParameterUtils.buildValueArray(parsedSql, new MapSqlParameterSource(map), null);
    }
}

