/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.SqlRowSetResultSetExtractor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.util.Assert;

public class NamedParameterJdbcTemplate
implements NamedParameterJdbcOperations {
    private final JdbcOperations classicJdbcTemplate;
    private final Map parsedSqlCache = new HashMap();
    static /* synthetic */ Class class$java$lang$Number;

    public NamedParameterJdbcTemplate(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"The [dataSource] argument cannot be null.");
        this.classicJdbcTemplate = new JdbcTemplate(dataSource);
    }

    public NamedParameterJdbcTemplate(JdbcOperations jdbcOperations) {
        Assert.notNull((Object)jdbcOperations, (String)"JdbcTemplate must not be null");
        this.classicJdbcTemplate = jdbcOperations;
    }

    public JdbcOperations getJdbcOperations() {
        return this.classicJdbcTemplate;
    }

    public Object execute(String string, SqlParameterSource sqlParameterSource, PreparedStatementCallback preparedStatementCallback) throws DataAccessException {
        return this.getJdbcOperations().execute(this.getPreparedStatementCreator(string, sqlParameterSource), preparedStatementCallback);
    }

    public Object execute(String string, Map map, PreparedStatementCallback preparedStatementCallback) throws DataAccessException {
        return this.execute(string, new MapSqlParameterSource(map), preparedStatementCallback);
    }

    public Object query(String string, SqlParameterSource sqlParameterSource, ResultSetExtractor resultSetExtractor) throws DataAccessException {
        return this.getJdbcOperations().query(this.getPreparedStatementCreator(string, sqlParameterSource), resultSetExtractor);
    }

    public Object query(String string, Map map, ResultSetExtractor resultSetExtractor) throws DataAccessException {
        return this.query(string, (SqlParameterSource)new MapSqlParameterSource(map), resultSetExtractor);
    }

    public void query(String string, SqlParameterSource sqlParameterSource, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.getJdbcOperations().query(this.getPreparedStatementCreator(string, sqlParameterSource), rowCallbackHandler);
    }

    public void query(String string, Map map, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(string, (SqlParameterSource)new MapSqlParameterSource(map), rowCallbackHandler);
    }

    public List query(String string, SqlParameterSource sqlParameterSource, RowMapper rowMapper) throws DataAccessException {
        return this.getJdbcOperations().query(this.getPreparedStatementCreator(string, sqlParameterSource), rowMapper);
    }

    public List query(String string, Map map, RowMapper rowMapper) throws DataAccessException {
        return this.query(string, (SqlParameterSource)new MapSqlParameterSource(map), rowMapper);
    }

    public Object queryForObject(String string, SqlParameterSource sqlParameterSource, RowMapper rowMapper) throws DataAccessException {
        List list = this.getJdbcOperations().query(this.getPreparedStatementCreator(string, sqlParameterSource), rowMapper);
        return DataAccessUtils.requiredSingleResult((Collection)list);
    }

    public Object queryForObject(String string, Map map, RowMapper rowMapper) throws DataAccessException {
        return this.queryForObject(string, (SqlParameterSource)new MapSqlParameterSource(map), rowMapper);
    }

    public Object queryForObject(String string, SqlParameterSource sqlParameterSource, Class clazz) throws DataAccessException {
        return this.queryForObject(string, sqlParameterSource, (RowMapper)new SingleColumnRowMapper(clazz));
    }

    public Object queryForObject(String string, Map map, Class clazz) throws DataAccessException {
        return this.queryForObject(string, map, (RowMapper)new SingleColumnRowMapper(clazz));
    }

    public Map queryForMap(String string, SqlParameterSource sqlParameterSource) throws DataAccessException {
        return (Map)this.queryForObject(string, sqlParameterSource, (RowMapper)new ColumnMapRowMapper());
    }

    public Map queryForMap(String string, Map map) throws DataAccessException {
        return (Map)this.queryForObject(string, map, (RowMapper)new ColumnMapRowMapper());
    }

    public long queryForLong(String string, SqlParameterSource sqlParameterSource) throws DataAccessException {
        Number number = (Number)this.queryForObject(string, sqlParameterSource, class$java$lang$Number == null ? (class$java$lang$Number = NamedParameterJdbcTemplate.class$("java.lang.Number")) : class$java$lang$Number);
        return number != null ? number.longValue() : 0L;
    }

    public long queryForLong(String string, Map map) throws DataAccessException {
        return this.queryForLong(string, new MapSqlParameterSource(map));
    }

    public int queryForInt(String string, SqlParameterSource sqlParameterSource) throws DataAccessException {
        Number number = (Number)this.queryForObject(string, sqlParameterSource, class$java$lang$Number == null ? (class$java$lang$Number = NamedParameterJdbcTemplate.class$("java.lang.Number")) : class$java$lang$Number);
        return number != null ? number.intValue() : 0;
    }

    public int queryForInt(String string, Map map) throws DataAccessException {
        return this.queryForInt(string, new MapSqlParameterSource(map));
    }

    public List queryForList(String string, SqlParameterSource sqlParameterSource, Class clazz) throws DataAccessException {
        return this.query(string, sqlParameterSource, (RowMapper)new SingleColumnRowMapper(clazz));
    }

    public List queryForList(String string, Map map, Class clazz) throws DataAccessException {
        return this.queryForList(string, new MapSqlParameterSource(map), clazz);
    }

    public List queryForList(String string, SqlParameterSource sqlParameterSource) throws DataAccessException {
        return this.query(string, sqlParameterSource, (RowMapper)new ColumnMapRowMapper());
    }

    public List queryForList(String string, Map map) throws DataAccessException {
        return this.queryForList(string, new MapSqlParameterSource(map));
    }

    public SqlRowSet queryForRowSet(String string, SqlParameterSource sqlParameterSource) throws DataAccessException {
        return (SqlRowSet)this.getJdbcOperations().query(this.getPreparedStatementCreator(string, sqlParameterSource), (ResultSetExtractor)new SqlRowSetResultSetExtractor());
    }

    public SqlRowSet queryForRowSet(String string, Map map) throws DataAccessException {
        return this.queryForRowSet(string, new MapSqlParameterSource(map));
    }

    public int update(String string, SqlParameterSource sqlParameterSource) throws DataAccessException {
        return this.getJdbcOperations().update(this.getPreparedStatementCreator(string, sqlParameterSource));
    }

    public int update(String string, Map map) throws DataAccessException {
        return this.update(string, new MapSqlParameterSource(map));
    }

    public int update(String string, SqlParameterSource sqlParameterSource, KeyHolder keyHolder) throws DataAccessException {
        return this.update(string, sqlParameterSource, keyHolder, null);
    }

    public int update(String string, SqlParameterSource sqlParameterSource, KeyHolder keyHolder, String[] stringArray) throws DataAccessException {
        ParsedSql parsedSql = this.getParsedSql(string);
        String string2 = NamedParameterUtils.substituteNamedParameters(parsedSql, sqlParameterSource);
        Object[] objectArray = NamedParameterUtils.buildValueArray(parsedSql, sqlParameterSource, null);
        int[] nArray = NamedParameterUtils.buildSqlTypeArray(parsedSql, sqlParameterSource);
        PreparedStatementCreatorFactory preparedStatementCreatorFactory = new PreparedStatementCreatorFactory(string2, nArray);
        if (stringArray != null) {
            preparedStatementCreatorFactory.setGeneratedKeysColumnNames(stringArray);
        } else {
            preparedStatementCreatorFactory.setReturnGeneratedKeys(true);
        }
        return this.getJdbcOperations().update(preparedStatementCreatorFactory.newPreparedStatementCreator(objectArray), keyHolder);
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String string, SqlParameterSource sqlParameterSource) {
        ParsedSql parsedSql = this.getParsedSql(string);
        String string2 = NamedParameterUtils.substituteNamedParameters(parsedSql, sqlParameterSource);
        Object[] objectArray = NamedParameterUtils.buildValueArray(parsedSql, sqlParameterSource, null);
        int[] nArray = NamedParameterUtils.buildSqlTypeArray(parsedSql, sqlParameterSource);
        PreparedStatementCreatorFactory preparedStatementCreatorFactory = new PreparedStatementCreatorFactory(string2, nArray);
        return preparedStatementCreatorFactory.newPreparedStatementCreator(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParsedSql getParsedSql(String string) {
        Map map = this.parsedSqlCache;
        synchronized (map) {
            ParsedSql parsedSql = (ParsedSql)this.parsedSqlCache.get(string);
            if (parsedSql == null) {
                parsedSql = NamedParameterUtils.parseSqlStatement(string);
                this.parsedSqlCache.put(string, parsedSql);
            }
            return parsedSql;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

