/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.springframework.util.Assert;

public class MapSqlParameterSource
extends AbstractSqlParameterSource {
    private final Map values = new HashMap();

    public MapSqlParameterSource() {
    }

    public MapSqlParameterSource(String string, Object object) {
        this.addValue(string, object);
    }

    public MapSqlParameterSource(Map map) {
        this.addValues(map);
    }

    public MapSqlParameterSource addValue(String string, Object object) {
        Assert.notNull((Object)string, (String)"Parameter name must not be null");
        this.values.put(string, object);
        return this;
    }

    public MapSqlParameterSource addValue(String string, Object object, int n) {
        Assert.notNull((Object)string, (String)"Parameter name must not be null");
        this.values.put(string, object);
        this.registerSqlType(string, n);
        return this;
    }

    public MapSqlParameterSource addValues(Map map) {
        if (map != null) {
            this.values.putAll(map);
        }
        return this;
    }

    public Map getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public boolean hasValue(String string) {
        return this.values.containsKey(string);
    }

    public Object getValue(String string) {
        if (!this.hasValue(string)) {
            throw new IllegalArgumentException("No value registered for key '" + string + "'");
        }
        return this.values.get(string);
    }
}

