/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.DisposableSqlTypeValue;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlTypeValue;
import org.springframework.util.ClassUtils;

public abstract class StatementCreatorUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jdbc$core$StatementCreatorUtils == null ? (class$org$springframework$jdbc$core$StatementCreatorUtils = StatementCreatorUtils.class$("org.springframework.jdbc.core.StatementCreatorUtils")) : class$org$springframework$jdbc$core$StatementCreatorUtils));
    private static final boolean charSequenceAvailable = ClassUtils.isPresent((String)"java.lang.CharSequence", (ClassLoader)(class$org$springframework$jdbc$core$StatementCreatorUtils == null ? (class$org$springframework$jdbc$core$StatementCreatorUtils = StatementCreatorUtils.class$("org.springframework.jdbc.core.StatementCreatorUtils")) : class$org$springframework$jdbc$core$StatementCreatorUtils).getClassLoader());
    static /* synthetic */ Class class$org$springframework$jdbc$core$StatementCreatorUtils;

    public static void setParameterValue(PreparedStatement preparedStatement, int n, SqlParameter sqlParameter, Object object) throws SQLException {
        StatementCreatorUtils.setParameterValueInternal(preparedStatement, n, sqlParameter.getSqlType(), sqlParameter.getTypeName(), sqlParameter.getScale(), object);
    }

    public static void setParameterValue(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        StatementCreatorUtils.setParameterValueInternal(preparedStatement, n, n2, null, null, object);
    }

    public static void setParameterValue(PreparedStatement preparedStatement, int n, int n2, String string, Object object) throws SQLException {
        StatementCreatorUtils.setParameterValueInternal(preparedStatement, n, n2, string, null, object);
    }

    private static void setParameterValueInternal(PreparedStatement preparedStatement, int n, int n2, String string, Integer n3, Object object) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting SQL statement parameter value: column index " + n + ", parameter value [" + object + "], value class [" + (object != null ? object.getClass().getName() : "null") + "], SQL type " + (n2 == Integer.MIN_VALUE ? "unknown" : Integer.toString(n2))));
        }
        if (object == null) {
            if (n2 == Integer.MIN_VALUE) {
                boolean bl = false;
                try {
                    bl = preparedStatement.getConnection().getMetaData().getDatabaseProductName().indexOf("Informix") != -1;
                }
                catch (Throwable throwable) {
                    logger.debug((Object)"Could not check database product name", throwable);
                }
                if (bl) {
                    preparedStatement.setObject(n, null);
                } else {
                    preparedStatement.setNull(n, 0);
                }
            } else if (string != null) {
                preparedStatement.setNull(n, n2, string);
            } else {
                preparedStatement.setNull(n, n2);
            }
        } else if (object instanceof SqlTypeValue) {
            ((SqlTypeValue)object).setTypeValue(preparedStatement, n, n2, string);
        } else if (n2 == 12) {
            preparedStatement.setString(n, object.toString());
        } else if (n2 == 3 || n2 == 2) {
            if (object instanceof BigDecimal) {
                preparedStatement.setBigDecimal(n, (BigDecimal)object);
            } else if (n3 != null) {
                preparedStatement.setObject(n, object, n2, (int)n3);
            } else {
                preparedStatement.setObject(n, object, n2);
            }
        } else if (n2 == 91) {
            if (object instanceof java.util.Date) {
                if (object instanceof Date) {
                    preparedStatement.setDate(n, (Date)object);
                } else {
                    preparedStatement.setDate(n, new Date(((java.util.Date)object).getTime()));
                }
            } else if (object instanceof Calendar) {
                Calendar calendar = (Calendar)object;
                preparedStatement.setDate(n, new Date(calendar.getTime().getTime()), calendar);
            } else {
                preparedStatement.setObject(n, object, 91);
            }
        } else if (n2 == 92) {
            if (object instanceof java.util.Date) {
                if (object instanceof Time) {
                    preparedStatement.setTime(n, (Time)object);
                } else {
                    preparedStatement.setTime(n, new Time(((java.util.Date)object).getTime()));
                }
            } else if (object instanceof Calendar) {
                Calendar calendar = (Calendar)object;
                preparedStatement.setTime(n, new Time(calendar.getTime().getTime()), calendar);
            } else {
                preparedStatement.setObject(n, object, 92);
            }
        } else if (n2 == 93) {
            if (object instanceof java.util.Date) {
                if (object instanceof Timestamp) {
                    preparedStatement.setTimestamp(n, (Timestamp)object);
                } else {
                    preparedStatement.setTimestamp(n, new Timestamp(((java.util.Date)object).getTime()));
                }
            } else if (object instanceof Calendar) {
                Calendar calendar = (Calendar)object;
                preparedStatement.setTimestamp(n, new Timestamp(calendar.getTime().getTime()), calendar);
            } else {
                preparedStatement.setObject(n, object, 93);
            }
        } else if (n2 == Integer.MIN_VALUE) {
            if (StatementCreatorUtils.isStringValue(object)) {
                preparedStatement.setString(n, object.toString());
            } else if (StatementCreatorUtils.isDateValue(object)) {
                preparedStatement.setTimestamp(n, new Timestamp(((java.util.Date)object).getTime()));
            } else if (object instanceof Calendar) {
                Calendar calendar = (Calendar)object;
                preparedStatement.setTimestamp(n, new Timestamp(calendar.getTime().getTime()));
            } else {
                preparedStatement.setObject(n, object);
            }
        } else {
            preparedStatement.setObject(n, object, n2);
        }
    }

    private static boolean isStringValue(Object object) {
        if (charSequenceAvailable) {
            return object instanceof CharSequence || object instanceof StringWriter;
        }
        return object instanceof String || object instanceof StringBuffer || object instanceof StringWriter;
    }

    private static boolean isDateValue(Object object) {
        return object instanceof java.util.Date && !(object instanceof Date) && !(object instanceof Time) && !(object instanceof Timestamp);
    }

    public static void cleanupParameters(Object[] objectArray) {
        if (objectArray != null) {
            StatementCreatorUtils.cleanupParameters(Arrays.asList(objectArray));
        }
    }

    public static void cleanupParameters(Collection collection) {
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof DisposableSqlTypeValue)) continue;
                ((DisposableSqlTypeValue)e).cleanup();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

