/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.util.LinkedList;
import java.util.List;
import org.springframework.util.Assert;

public class SqlParameter {
    private String name;
    private final int sqlType;
    private String typeName;
    private Integer scale;

    public SqlParameter(int n) {
        this.sqlType = n;
    }

    public SqlParameter(int n, String string) {
        this.sqlType = n;
        this.typeName = string;
    }

    public SqlParameter(int n, int n2) {
        this.sqlType = n;
        this.scale = new Integer(n2);
    }

    public SqlParameter(String string, int n) {
        this.name = string;
        this.sqlType = n;
    }

    public SqlParameter(String string, int n, String string2) {
        this.name = string;
        this.sqlType = n;
        this.typeName = string2;
    }

    public SqlParameter(String string, int n, int n2) {
        this.name = string;
        this.sqlType = n;
        this.scale = new Integer(n2);
    }

    public SqlParameter(SqlParameter sqlParameter) {
        Assert.notNull((Object)sqlParameter, (String)"SqlParameter object must not be null");
        this.name = sqlParameter.name;
        this.sqlType = sqlParameter.sqlType;
        this.typeName = sqlParameter.typeName;
        this.scale = sqlParameter.scale;
    }

    public String getName() {
        return this.name;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Integer getScale() {
        return this.scale;
    }

    public static List sqlTypesToAnonymousParameterList(int[] nArray) {
        LinkedList<SqlParameter> linkedList = new LinkedList<SqlParameter>();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                linkedList.add(new SqlParameter(nArray[i]));
            }
        }
        return linkedList;
    }
}

