/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.NumberUtils;

public class SingleColumnRowMapper
implements RowMapper {
    private Class requiredType;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;

    public SingleColumnRowMapper() {
    }

    public SingleColumnRowMapper(Class clazz) {
        this.requiredType = clazz;
    }

    public void setRequiredType(Class clazz) {
        this.requiredType = clazz;
    }

    public Object mapRow(ResultSet resultSet, int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        if (n2 != 1) {
            throw new IncorrectResultSetColumnCountException(1, n2);
        }
        Object object = this.getColumnValue(resultSet, 1, this.requiredType);
        if (object != null && this.requiredType != null && !this.requiredType.isInstance(object)) {
            try {
                return this.convertValueToRequiredType(object, this.requiredType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new TypeMismatchDataAccessException("Type mismatch affecting row number " + n + " and column type '" + resultSetMetaData.getColumnTypeName(1) + "': " + illegalArgumentException.getMessage());
            }
        }
        return object;
    }

    protected Object getColumnValue(ResultSet resultSet, int n, Class clazz) throws SQLException {
        if (clazz != null) {
            Object object = null;
            boolean bl = false;
            if ((class$java$lang$String == null ? (class$java$lang$String = SingleColumnRowMapper.class$("java.lang.String")) : class$java$lang$String).equals(clazz)) {
                object = resultSet.getString(n);
            } else if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = SingleColumnRowMapper.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(clazz)) {
                object = resultSet.getBoolean(n) ? Boolean.TRUE : Boolean.FALSE;
                bl = true;
            } else if ((class$java$lang$Byte == null ? (class$java$lang$Byte = SingleColumnRowMapper.class$("java.lang.Byte")) : class$java$lang$Byte).equals(clazz)) {
                object = new Byte(resultSet.getByte(n));
                bl = true;
            } else if ((class$java$lang$Short == null ? (class$java$lang$Short = SingleColumnRowMapper.class$("java.lang.Short")) : class$java$lang$Short).equals(clazz)) {
                object = new Short(resultSet.getShort(n));
                bl = true;
            } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = SingleColumnRowMapper.class$("java.lang.Integer")) : class$java$lang$Integer).equals(clazz)) {
                object = new Integer(resultSet.getInt(n));
                bl = true;
            } else if ((class$java$lang$Long == null ? (class$java$lang$Long = SingleColumnRowMapper.class$("java.lang.Long")) : class$java$lang$Long).equals(clazz)) {
                object = new Long(resultSet.getLong(n));
                bl = true;
            } else if ((class$java$lang$Float == null ? (class$java$lang$Float = SingleColumnRowMapper.class$("java.lang.Float")) : class$java$lang$Float).equals(clazz)) {
                object = new Float(resultSet.getFloat(n));
                bl = true;
            } else if ((class$java$lang$Double == null ? (class$java$lang$Double = SingleColumnRowMapper.class$("java.lang.Double")) : class$java$lang$Double).equals(clazz) || (class$java$lang$Number == null ? (class$java$lang$Number = SingleColumnRowMapper.class$("java.lang.Number")) : class$java$lang$Number).equals(clazz)) {
                object = new Double(resultSet.getDouble(n));
                bl = true;
            } else {
                object = (array$B == null ? (array$B = SingleColumnRowMapper.class$("[B")) : array$B).equals(clazz) ? (Object)resultSet.getBytes(n) : ((class$java$sql$Date == null ? (class$java$sql$Date = SingleColumnRowMapper.class$("java.sql.Date")) : class$java$sql$Date).equals(clazz) ? resultSet.getDate(n) : ((class$java$sql$Time == null ? (class$java$sql$Time = SingleColumnRowMapper.class$("java.sql.Time")) : class$java$sql$Time).equals(clazz) ? resultSet.getTime(n) : ((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SingleColumnRowMapper.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).equals(clazz) || (class$java$util$Date == null ? (class$java$util$Date = SingleColumnRowMapper.class$("java.util.Date")) : class$java$util$Date).equals(clazz) ? resultSet.getTimestamp(n) : ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SingleColumnRowMapper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).equals(clazz) ? resultSet.getBigDecimal(n) : ((class$java$sql$Blob == null ? (class$java$sql$Blob = SingleColumnRowMapper.class$("java.sql.Blob")) : class$java$sql$Blob).equals(clazz) ? resultSet.getBlob(n) : ((class$java$sql$Clob == null ? (class$java$sql$Clob = SingleColumnRowMapper.class$("java.sql.Clob")) : class$java$sql$Clob).equals(clazz) ? resultSet.getClob(n) : resultSet.getObject(n)))))));
            }
            if (bl && object != null && resultSet.wasNull()) {
                object = null;
            }
            return object;
        }
        return this.getColumnValue(resultSet, n);
    }

    protected Object getColumnValue(ResultSet resultSet, int n) throws SQLException {
        return JdbcUtils.getResultSetValue(resultSet, n);
    }

    protected Object convertValueToRequiredType(Object object, Class clazz) {
        if ((class$java$lang$String == null ? (class$java$lang$String = SingleColumnRowMapper.class$("java.lang.String")) : class$java$lang$String).equals(this.requiredType)) {
            return object.toString();
        }
        if ((class$java$lang$Number == null ? (class$java$lang$Number = SingleColumnRowMapper.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(this.requiredType)) {
            if (object instanceof Number) {
                return NumberUtils.convertNumberToTargetClass((Number)((Number)object), (Class)this.requiredType);
            }
            return NumberUtils.parseNumber((String)object.toString(), (Class)this.requiredType);
        }
        throw new IllegalArgumentException("Value [" + object + "] is of type [" + object.getClass().getName() + "] and cannot be converted to required type [" + this.requiredType.getName() + "]");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

