/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.springframework.jdbc.core.RowCallbackHandler;

public class RowCountCallbackHandler
implements RowCallbackHandler {
    private int rowCount;
    private int columnCount;
    private int[] columnTypes;
    private String[] columnNames;

    public final void processRow(ResultSet resultSet) throws SQLException {
        if (this.rowCount == 0) {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.columnCount = resultSetMetaData.getColumnCount();
            this.columnTypes = new int[this.columnCount];
            this.columnNames = new String[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                this.columnTypes[i] = resultSetMetaData.getColumnType(i + 1);
                this.columnNames[i] = resultSetMetaData.getColumnName(i + 1);
            }
        }
        this.processRow(resultSet, this.rowCount++);
    }

    protected void processRow(ResultSet resultSet, int n) throws SQLException {
    }

    public final int[] getColumnTypes() {
        return this.columnTypes;
    }

    public final String[] getColumnNames() {
        return this.columnNames;
    }

    public final int getRowCount() {
        return this.rowCount;
    }

    public final int getColumnCount() {
        return this.columnCount;
    }
}

