/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.util.Assert;

public class PreparedStatementCreatorFactory {
    private final String sql;
    private final List declaredParameters;
    private int resultSetType = 1003;
    private boolean updatableResults = false;
    private boolean returnGeneratedKeys = false;
    private String[] generatedKeysColumnNames = null;
    private NativeJdbcExtractor nativeJdbcExtractor;

    public PreparedStatementCreatorFactory(String string) {
        this.sql = string;
        this.declaredParameters = new LinkedList();
    }

    public PreparedStatementCreatorFactory(String string, int[] nArray) {
        this.sql = string;
        this.declaredParameters = SqlParameter.sqlTypesToAnonymousParameterList(nArray);
    }

    public PreparedStatementCreatorFactory(String string, List list) {
        this.sql = string;
        this.declaredParameters = list;
    }

    public void addParameter(SqlParameter sqlParameter) {
        this.declaredParameters.add(sqlParameter);
    }

    public void setResultSetType(int n) {
        this.resultSetType = n;
    }

    public void setUpdatableResults(boolean bl) {
        this.updatableResults = bl;
    }

    public void setReturnGeneratedKeys(boolean bl) {
        this.returnGeneratedKeys = bl;
    }

    public void setGeneratedKeysColumnNames(String[] stringArray) {
        this.generatedKeysColumnNames = stringArray;
    }

    public void setNativeJdbcExtractor(NativeJdbcExtractor nativeJdbcExtractor) {
        this.nativeJdbcExtractor = nativeJdbcExtractor;
    }

    public PreparedStatementSetter newPreparedStatementSetter(List list) {
        return new PreparedStatementCreatorImpl(list != null ? list : Collections.EMPTY_LIST);
    }

    public PreparedStatementSetter newPreparedStatementSetter(Object[] objectArray) {
        return new PreparedStatementCreatorImpl(objectArray != null ? Arrays.asList(objectArray) : Collections.EMPTY_LIST);
    }

    public PreparedStatementCreator newPreparedStatementCreator(List list) {
        return new PreparedStatementCreatorImpl(list != null ? list : Collections.EMPTY_LIST);
    }

    public PreparedStatementCreator newPreparedStatementCreator(Object[] objectArray) {
        return new PreparedStatementCreatorImpl(objectArray != null ? Arrays.asList(objectArray) : Collections.EMPTY_LIST);
    }

    public PreparedStatementCreator newPreparedStatementCreator(String string, Object[] objectArray) {
        return new PreparedStatementCreatorImpl(string, objectArray != null ? Arrays.asList(objectArray) : Collections.EMPTY_LIST);
    }

    private class PreparedStatementCreatorImpl
    implements PreparedStatementCreator,
    PreparedStatementSetter,
    SqlProvider,
    ParameterDisposer {
        private final String actualSql;
        private final List parameters;

        public PreparedStatementCreatorImpl(List list) {
            this(preparedStatementCreatorFactory.sql, list);
        }

        public PreparedStatementCreatorImpl(String string, List list) {
            this.actualSql = string;
            Assert.notNull((Object)list, (String)"Parameters List must not be null");
            this.parameters = list;
            if (this.parameters.size() != PreparedStatementCreatorFactory.this.declaredParameters.size()) {
                throw new InvalidDataAccessApiUsageException("SQL [" + PreparedStatementCreatorFactory.this.sql + "]: given " + this.parameters.size() + " parameters but expected " + PreparedStatementCreatorFactory.this.declaredParameters.size());
            }
        }

        public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
            PreparedStatement preparedStatement = null;
            if (PreparedStatementCreatorFactory.this.generatedKeysColumnNames != null || PreparedStatementCreatorFactory.this.returnGeneratedKeys) {
                try {
                    if (PreparedStatementCreatorFactory.this.generatedKeysColumnNames != null) {
                        preparedStatement = connection.prepareStatement(this.actualSql, PreparedStatementCreatorFactory.this.generatedKeysColumnNames);
                    }
                    preparedStatement = connection.prepareStatement(this.actualSql, 1);
                }
                catch (AbstractMethodError abstractMethodError) {
                    throw new InvalidDataAccessResourceUsageException("The JDBC driver is not compliant to JDBC 3.0 and thus does not support retrieval of auto-generated keys", (Throwable)abstractMethodError);
                }
            } else {
                preparedStatement = PreparedStatementCreatorFactory.this.resultSetType == 1003 && !PreparedStatementCreatorFactory.this.updatableResults ? connection.prepareStatement(this.actualSql) : connection.prepareStatement(this.actualSql, PreparedStatementCreatorFactory.this.resultSetType, PreparedStatementCreatorFactory.this.updatableResults ? 1008 : 1007);
            }
            this.setValues(preparedStatement);
            return preparedStatement;
        }

        public void setValues(PreparedStatement preparedStatement) throws SQLException {
            PreparedStatement preparedStatement2 = preparedStatement;
            if (PreparedStatementCreatorFactory.this.nativeJdbcExtractor != null) {
                preparedStatement2 = PreparedStatementCreatorFactory.this.nativeJdbcExtractor.getNativePreparedStatement(preparedStatement);
            }
            int n = 1;
            for (int i = 0; i < this.parameters.size(); ++i) {
                Object object;
                Object object2 = this.parameters.get(i);
                SqlParameter sqlParameter = null;
                if (object2 instanceof SqlParameterValue) {
                    object = (SqlParameterValue)object2;
                    object2 = ((SqlParameterValue)object).getValue();
                    sqlParameter = object;
                } else {
                    sqlParameter = (SqlParameter)PreparedStatementCreatorFactory.this.declaredParameters.get(i);
                }
                if (object2 instanceof Collection && sqlParameter.getSqlType() != 2003) {
                    object = (Collection)object2;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        StatementCreatorUtils.setParameterValue(preparedStatement2, n++, sqlParameter, e);
                    }
                    continue;
                }
                StatementCreatorUtils.setParameterValue(preparedStatement2, n++, sqlParameter, object2);
            }
        }

        public String getSql() {
            return PreparedStatementCreatorFactory.this.sql;
        }

        public void cleanupParameters() {
            StatementCreatorUtils.cleanupParameters(this.parameters);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("PreparedStatementCreatorFactory.PreparedStatementCreatorImpl: sql=[");
            stringBuffer.append(PreparedStatementCreatorFactory.this.sql).append("]; parameters=").append(this.parameters);
            return stringBuffer.toString();
        }
    }
}

