/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.SQLWarningException;
import org.springframework.jdbc.core.ArgPreparedStatementSetter;
import org.springframework.jdbc.core.ArgTypePreparedStatementSetter;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.InterruptibleBatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.ResultSetSupportingSqlParameter;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.jdbc.core.SqlReturnResultSet;
import org.springframework.jdbc.core.SqlRowSetResultSetExtractor;
import org.springframework.jdbc.core.StatementCallback;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.util.Assert;

public class JdbcTemplate
extends JdbcAccessor
implements JdbcOperations {
    private NativeJdbcExtractor nativeJdbcExtractor;
    private boolean ignoreWarnings = true;
    private int fetchSize = 0;
    private int maxRows = 0;
    private int queryTimeout = 0;
    private boolean skipResultsProcessing = false;
    static /* synthetic */ Class class$org$springframework$jdbc$datasource$ConnectionProxy;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;

    public JdbcTemplate() {
    }

    public JdbcTemplate(DataSource dataSource) {
        this.setDataSource(dataSource);
        this.afterPropertiesSet();
    }

    public JdbcTemplate(DataSource dataSource, boolean bl) {
        this.setDataSource(dataSource);
        this.setLazyInit(bl);
        this.afterPropertiesSet();
    }

    public void setNativeJdbcExtractor(NativeJdbcExtractor nativeJdbcExtractor) {
        this.nativeJdbcExtractor = nativeJdbcExtractor;
    }

    public NativeJdbcExtractor getNativeJdbcExtractor() {
        return this.nativeJdbcExtractor;
    }

    public void setIgnoreWarnings(boolean bl) {
        this.ignoreWarnings = bl;
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setSkipResultsProcessing(boolean bl) {
        this.skipResultsProcessing = bl;
    }

    public boolean isSkipResultsProcessing() {
        return this.skipResultsProcessing;
    }

    public Object execute(ConnectionCallback connectionCallback) throws DataAccessException {
        Assert.notNull((Object)connectionCallback, (String)"Callback object must not be null");
        Connection connection = DataSourceUtils.getConnection(this.getDataSource());
        try {
            Connection connection2 = connection;
            connection2 = this.nativeJdbcExtractor != null ? this.nativeJdbcExtractor.getNativeConnection(connection) : this.createConnectionProxy(connection);
            Object object = connectionCallback.doInConnection(connection2);
            return object;
        }
        catch (SQLException sQLException) {
            DataSourceUtils.releaseConnection(connection, this.getDataSource());
            connection = null;
            throw this.getExceptionTranslator().translate("ConnectionCallback", JdbcTemplate.getSql(connectionCallback), sQLException);
        }
        finally {
            DataSourceUtils.releaseConnection(connection, this.getDataSource());
        }
    }

    protected Connection createConnectionProxy(Connection connection) {
        return (Connection)Proxy.newProxyInstance((class$org$springframework$jdbc$datasource$ConnectionProxy == null ? (class$org$springframework$jdbc$datasource$ConnectionProxy = JdbcTemplate.class$("org.springframework.jdbc.datasource.ConnectionProxy")) : class$org$springframework$jdbc$datasource$ConnectionProxy).getClassLoader(), new Class[]{class$org$springframework$jdbc$datasource$ConnectionProxy == null ? (class$org$springframework$jdbc$datasource$ConnectionProxy = JdbcTemplate.class$("org.springframework.jdbc.datasource.ConnectionProxy")) : class$org$springframework$jdbc$datasource$ConnectionProxy}, (InvocationHandler)new CloseSuppressingInvocationHandler(connection));
    }

    public Object execute(StatementCallback statementCallback) throws DataAccessException {
        Object object;
        Assert.notNull((Object)statementCallback, (String)"Callback object must not be null");
        Connection connection = DataSourceUtils.getConnection(this.getDataSource());
        Statement statement = null;
        try {
            Connection connection2 = connection;
            if (this.nativeJdbcExtractor != null && this.nativeJdbcExtractor.isNativeConnectionNecessaryForNativeStatements()) {
                connection2 = this.nativeJdbcExtractor.getNativeConnection(connection);
            }
            statement = connection2.createStatement();
            this.applyStatementSettings(statement);
            Statement statement2 = statement;
            if (this.nativeJdbcExtractor != null) {
                statement2 = this.nativeJdbcExtractor.getNativeStatement(statement);
            }
            Object object2 = statementCallback.doInStatement(statement2);
            this.handleWarnings(statement.getWarnings());
            object = object2;
        }
        catch (SQLException sQLException) {
            try {
                JdbcUtils.closeStatement(statement);
                statement = null;
                DataSourceUtils.releaseConnection(connection, this.getDataSource());
                connection = null;
                throw this.getExceptionTranslator().translate("StatementCallback", JdbcTemplate.getSql(statementCallback), sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(statement);
                DataSourceUtils.releaseConnection(connection, this.getDataSource());
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(statement);
        DataSourceUtils.releaseConnection(connection, this.getDataSource());
        return object;
    }

    public void execute(String string) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing SQL statement [" + string + "]"));
        }
        class ExecuteStatementCallback
        implements StatementCallback,
        SqlProvider {
            private final /* synthetic */ String val$sql;

            ExecuteStatementCallback(String string) {
                this.val$sql = string;
            }

            public Object doInStatement(Statement statement) throws SQLException {
                statement.execute(this.val$sql);
                return null;
            }

            public String getSql() {
                return this.val$sql;
            }
        }
        this.execute(new ExecuteStatementCallback(string));
    }

    public Object query(String string, ResultSetExtractor resultSetExtractor) throws DataAccessException {
        Assert.notNull((Object)string, (String)"SQL must not be null");
        Assert.notNull((Object)resultSetExtractor, (String)"ResultSetExtractor must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing SQL query [" + string + "]"));
        }
        class QueryStatementCallback
        implements StatementCallback,
        SqlProvider {
            private final /* synthetic */ String val$sql;
            private final /* synthetic */ ResultSetExtractor val$rse;

            QueryStatementCallback(String string, ResultSetExtractor resultSetExtractor) {
                this.val$sql = string;
                this.val$rse = resultSetExtractor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInStatement(Statement statement) throws SQLException {
                Object object;
                ResultSet resultSet = null;
                try {
                    ResultSet resultSet2 = resultSet = statement.executeQuery(this.val$sql);
                    if (JdbcTemplate.this.nativeJdbcExtractor != null) {
                        resultSet2 = JdbcTemplate.this.nativeJdbcExtractor.getNativeResultSet(resultSet);
                    }
                    object = this.val$rse.extractData(resultSet2);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(resultSet);
                    throw throwable;
                }
                JdbcUtils.closeResultSet(resultSet);
                return object;
            }

            public String getSql() {
                return this.val$sql;
            }
        }
        return this.execute(new QueryStatementCallback(string, resultSetExtractor));
    }

    public void query(String string, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(string, (ResultSetExtractor)new RowCallbackHandlerResultSetExtractor(rowCallbackHandler));
    }

    public List query(String string, RowMapper rowMapper) throws DataAccessException {
        return (List)this.query(string, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper));
    }

    public Map queryForMap(String string) throws DataAccessException {
        return (Map)this.queryForObject(string, this.getColumnMapRowMapper());
    }

    public Object queryForObject(String string, RowMapper rowMapper) throws DataAccessException {
        List list = this.query(string, rowMapper);
        return DataAccessUtils.requiredSingleResult((Collection)list);
    }

    public Object queryForObject(String string, Class clazz) throws DataAccessException {
        return this.queryForObject(string, this.getSingleColumnRowMapper(clazz));
    }

    public long queryForLong(String string) throws DataAccessException {
        Number number = (Number)this.queryForObject(string, class$java$lang$Long == null ? (class$java$lang$Long = JdbcTemplate.class$("java.lang.Long")) : class$java$lang$Long);
        return number != null ? number.longValue() : 0L;
    }

    public int queryForInt(String string) throws DataAccessException {
        Number number = (Number)this.queryForObject(string, class$java$lang$Integer == null ? (class$java$lang$Integer = JdbcTemplate.class$("java.lang.Integer")) : class$java$lang$Integer);
        return number != null ? number.intValue() : 0;
    }

    public List queryForList(String string, Class clazz) throws DataAccessException {
        return this.query(string, this.getSingleColumnRowMapper(clazz));
    }

    public List queryForList(String string) throws DataAccessException {
        return this.query(string, this.getColumnMapRowMapper());
    }

    public SqlRowSet queryForRowSet(String string) throws DataAccessException {
        return (SqlRowSet)this.query(string, (ResultSetExtractor)new SqlRowSetResultSetExtractor());
    }

    public int update(String string) throws DataAccessException {
        Assert.notNull((Object)string, (String)"SQL must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing SQL update [" + string + "]"));
        }
        class UpdateStatementCallback
        implements StatementCallback,
        SqlProvider {
            private final /* synthetic */ String val$sql;

            UpdateStatementCallback(String string) {
                this.val$sql = string;
            }

            public Object doInStatement(Statement statement) throws SQLException {
                int n = statement.executeUpdate(this.val$sql);
                if (JdbcTemplate.this.logger.isDebugEnabled()) {
                    JdbcTemplate.this.logger.debug((Object)("SQL update affected " + n + " rows"));
                }
                return new Integer(n);
            }

            public String getSql() {
                return this.val$sql;
            }
        }
        return (Integer)this.execute(new UpdateStatementCallback(string));
    }

    public int[] batchUpdate(String[] stringArray) throws DataAccessException {
        Assert.notEmpty((Object[])stringArray, (String)"SQL array must not be empty");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing SQL batch update of " + stringArray.length + " statements"));
        }
        class BatchUpdateStatementCallback
        implements StatementCallback,
        SqlProvider {
            private String currSql;
            private final /* synthetic */ String[] val$sql;

            BatchUpdateStatementCallback(String[] stringArray) {
                this.val$sql = stringArray;
            }

            public Object doInStatement(Statement statement) throws SQLException, DataAccessException {
                int[] nArray = new int[this.val$sql.length];
                if (JdbcUtils.supportsBatchUpdates(statement.getConnection())) {
                    for (int i = 0; i < this.val$sql.length; ++i) {
                        this.currSql = this.val$sql[i];
                        statement.addBatch(this.val$sql[i]);
                    }
                    nArray = statement.executeBatch();
                } else {
                    for (int i = 0; i < this.val$sql.length; ++i) {
                        this.currSql = this.val$sql[i];
                        if (statement.execute(this.val$sql[i])) {
                            throw new InvalidDataAccessApiUsageException("Invalid batch SQL statement: " + this.val$sql[i]);
                        }
                        nArray[i] = statement.getUpdateCount();
                    }
                }
                return nArray;
            }

            public String getSql() {
                return this.currSql;
            }
        }
        return (int[])this.execute(new BatchUpdateStatementCallback(stringArray));
    }

    public Object execute(PreparedStatementCreator preparedStatementCreator, PreparedStatementCallback preparedStatementCallback) throws DataAccessException {
        Object object;
        Object object2;
        Assert.notNull((Object)preparedStatementCreator, (String)"PreparedStatementCreator must not be null");
        Assert.notNull((Object)preparedStatementCallback, (String)"Callback object must not be null");
        if (this.logger.isDebugEnabled()) {
            object2 = JdbcTemplate.getSql(preparedStatementCreator);
            this.logger.debug((Object)("Executing prepared SQL statement" + (object2 != null ? " [" + (String)object2 + "]" : "")));
        }
        object2 = DataSourceUtils.getConnection(this.getDataSource());
        PreparedStatement preparedStatement = null;
        try {
            Object object3 = object2;
            if (this.nativeJdbcExtractor != null && this.nativeJdbcExtractor.isNativeConnectionNecessaryForNativePreparedStatements()) {
                object3 = this.nativeJdbcExtractor.getNativeConnection((Connection)object2);
            }
            preparedStatement = preparedStatementCreator.createPreparedStatement((Connection)object3);
            this.applyStatementSettings(preparedStatement);
            PreparedStatement preparedStatement2 = preparedStatement;
            if (this.nativeJdbcExtractor != null) {
                preparedStatement2 = this.nativeJdbcExtractor.getNativePreparedStatement(preparedStatement);
            }
            Object object4 = preparedStatementCallback.doInPreparedStatement(preparedStatement2);
            this.handleWarnings(preparedStatement.getWarnings());
            object = object4;
        }
        catch (SQLException sQLException) {
            try {
                if (preparedStatementCreator instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)preparedStatementCreator)).cleanupParameters();
                }
                String string = JdbcTemplate.getSql(preparedStatementCreator);
                preparedStatementCreator = null;
                JdbcUtils.closeStatement(preparedStatement);
                preparedStatement = null;
                DataSourceUtils.releaseConnection((Connection)object2, this.getDataSource());
                object2 = null;
                throw this.getExceptionTranslator().translate("PreparedStatementCallback", string, sQLException);
            }
            catch (Throwable throwable) {
                if (preparedStatementCreator instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)preparedStatementCreator)).cleanupParameters();
                }
                JdbcUtils.closeStatement(preparedStatement);
                DataSourceUtils.releaseConnection((Connection)object2, this.getDataSource());
                throw throwable;
            }
        }
        if (preparedStatementCreator instanceof ParameterDisposer) {
            ((ParameterDisposer)((Object)preparedStatementCreator)).cleanupParameters();
        }
        JdbcUtils.closeStatement(preparedStatement);
        DataSourceUtils.releaseConnection((Connection)object2, this.getDataSource());
        return object;
    }

    public Object execute(String string, PreparedStatementCallback preparedStatementCallback) throws DataAccessException {
        return this.execute(new SimplePreparedStatementCreator(string), preparedStatementCallback);
    }

    public Object query(PreparedStatementCreator preparedStatementCreator, final PreparedStatementSetter preparedStatementSetter, final ResultSetExtractor resultSetExtractor) throws DataAccessException {
        Assert.notNull((Object)resultSetExtractor, (String)"ResultSetExtractor must not be null");
        this.logger.debug((Object)"Executing prepared SQL query");
        return this.execute(preparedStatementCreator, new PreparedStatementCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInPreparedStatement(PreparedStatement preparedStatement) throws SQLException {
                Object object;
                ResultSet resultSet = null;
                try {
                    if (preparedStatementSetter != null) {
                        preparedStatementSetter.setValues(preparedStatement);
                    }
                    ResultSet resultSet2 = resultSet = preparedStatement.executeQuery();
                    if (JdbcTemplate.this.nativeJdbcExtractor != null) {
                        resultSet2 = JdbcTemplate.this.nativeJdbcExtractor.getNativeResultSet(resultSet);
                    }
                    object = resultSetExtractor.extractData(resultSet2);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(resultSet);
                    if (preparedStatementSetter instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)preparedStatementSetter)).cleanupParameters();
                    }
                    throw throwable;
                }
                JdbcUtils.closeResultSet(resultSet);
                if (preparedStatementSetter instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)preparedStatementSetter)).cleanupParameters();
                }
                return object;
            }
        });
    }

    public Object query(PreparedStatementCreator preparedStatementCreator, ResultSetExtractor resultSetExtractor) throws DataAccessException {
        return this.query(preparedStatementCreator, null, resultSetExtractor);
    }

    public Object query(String string, PreparedStatementSetter preparedStatementSetter, ResultSetExtractor resultSetExtractor) throws DataAccessException {
        return this.query(new SimplePreparedStatementCreator(string), preparedStatementSetter, resultSetExtractor);
    }

    public Object query(String string, Object[] objectArray, int[] nArray, ResultSetExtractor resultSetExtractor) throws DataAccessException {
        return this.query(string, (PreparedStatementSetter)new ArgTypePreparedStatementSetter(objectArray, nArray), resultSetExtractor);
    }

    public Object query(String string, Object[] objectArray, ResultSetExtractor resultSetExtractor) throws DataAccessException {
        return this.query(string, (PreparedStatementSetter)new ArgPreparedStatementSetter(objectArray), resultSetExtractor);
    }

    public void query(PreparedStatementCreator preparedStatementCreator, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(preparedStatementCreator, (ResultSetExtractor)new RowCallbackHandlerResultSetExtractor(rowCallbackHandler));
    }

    public void query(String string, PreparedStatementSetter preparedStatementSetter, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(string, preparedStatementSetter, (ResultSetExtractor)new RowCallbackHandlerResultSetExtractor(rowCallbackHandler));
    }

    public void query(String string, Object[] objectArray, int[] nArray, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(string, (PreparedStatementSetter)new ArgTypePreparedStatementSetter(objectArray, nArray), rowCallbackHandler);
    }

    public void query(String string, Object[] objectArray, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(string, (PreparedStatementSetter)new ArgPreparedStatementSetter(objectArray), rowCallbackHandler);
    }

    public List query(PreparedStatementCreator preparedStatementCreator, RowMapper rowMapper) throws DataAccessException {
        return (List)this.query(preparedStatementCreator, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper));
    }

    public List query(String string, PreparedStatementSetter preparedStatementSetter, RowMapper rowMapper) throws DataAccessException {
        return (List)this.query(string, preparedStatementSetter, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper));
    }

    public List query(String string, Object[] objectArray, int[] nArray, RowMapper rowMapper) throws DataAccessException {
        return (List)this.query(string, objectArray, nArray, new RowMapperResultSetExtractor(rowMapper));
    }

    public List query(String string, Object[] objectArray, RowMapper rowMapper) throws DataAccessException {
        return (List)this.query(string, objectArray, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper));
    }

    public Object queryForObject(String string, Object[] objectArray, int[] nArray, RowMapper rowMapper) throws DataAccessException {
        List list = (List)this.query(string, objectArray, nArray, new RowMapperResultSetExtractor(rowMapper, 1));
        return DataAccessUtils.requiredSingleResult((Collection)list);
    }

    public Object queryForObject(String string, Object[] objectArray, RowMapper rowMapper) throws DataAccessException {
        List list = (List)this.query(string, objectArray, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper, 1));
        return DataAccessUtils.requiredSingleResult((Collection)list);
    }

    public Object queryForObject(String string, Object[] objectArray, int[] nArray, Class clazz) throws DataAccessException {
        return this.queryForObject(string, objectArray, nArray, this.getSingleColumnRowMapper(clazz));
    }

    public Object queryForObject(String string, Object[] objectArray, Class clazz) throws DataAccessException {
        return this.queryForObject(string, objectArray, this.getSingleColumnRowMapper(clazz));
    }

    public Map queryForMap(String string, Object[] objectArray, int[] nArray) throws DataAccessException {
        return (Map)this.queryForObject(string, objectArray, nArray, this.getColumnMapRowMapper());
    }

    public Map queryForMap(String string, Object[] objectArray) throws DataAccessException {
        return (Map)this.queryForObject(string, objectArray, this.getColumnMapRowMapper());
    }

    public long queryForLong(String string, Object[] objectArray, int[] nArray) throws DataAccessException {
        Number number = (Number)this.queryForObject(string, objectArray, nArray, class$java$lang$Long == null ? (class$java$lang$Long = JdbcTemplate.class$("java.lang.Long")) : class$java$lang$Long);
        return number != null ? number.longValue() : 0L;
    }

    public long queryForLong(String string, Object[] objectArray) throws DataAccessException {
        Number number = (Number)this.queryForObject(string, objectArray, class$java$lang$Long == null ? (class$java$lang$Long = JdbcTemplate.class$("java.lang.Long")) : class$java$lang$Long);
        return number != null ? number.longValue() : 0L;
    }

    public int queryForInt(String string, Object[] objectArray, int[] nArray) throws DataAccessException {
        Number number = (Number)this.queryForObject(string, objectArray, nArray, class$java$lang$Integer == null ? (class$java$lang$Integer = JdbcTemplate.class$("java.lang.Integer")) : class$java$lang$Integer);
        return number != null ? number.intValue() : 0;
    }

    public int queryForInt(String string, Object[] objectArray) throws DataAccessException {
        Number number = (Number)this.queryForObject(string, objectArray, class$java$lang$Integer == null ? (class$java$lang$Integer = JdbcTemplate.class$("java.lang.Integer")) : class$java$lang$Integer);
        return number != null ? number.intValue() : 0;
    }

    public List queryForList(String string, Object[] objectArray, int[] nArray, Class clazz) throws DataAccessException {
        return this.query(string, objectArray, nArray, this.getSingleColumnRowMapper(clazz));
    }

    public List queryForList(String string, Object[] objectArray, Class clazz) throws DataAccessException {
        return this.query(string, objectArray, this.getSingleColumnRowMapper(clazz));
    }

    public List queryForList(String string, Object[] objectArray, int[] nArray) throws DataAccessException {
        return this.query(string, objectArray, nArray, this.getColumnMapRowMapper());
    }

    public List queryForList(String string, Object[] objectArray) throws DataAccessException {
        return this.query(string, objectArray, this.getColumnMapRowMapper());
    }

    public SqlRowSet queryForRowSet(String string, Object[] objectArray, int[] nArray) throws DataAccessException {
        return (SqlRowSet)this.query(string, objectArray, nArray, new SqlRowSetResultSetExtractor());
    }

    public SqlRowSet queryForRowSet(String string, Object[] objectArray) throws DataAccessException {
        return (SqlRowSet)this.query(string, objectArray, (ResultSetExtractor)new SqlRowSetResultSetExtractor());
    }

    protected int update(PreparedStatementCreator preparedStatementCreator, final PreparedStatementSetter preparedStatementSetter) throws DataAccessException {
        this.logger.debug((Object)"Executing prepared SQL update");
        Integer n = (Integer)this.execute(preparedStatementCreator, new PreparedStatementCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInPreparedStatement(PreparedStatement preparedStatement) throws SQLException {
                try {
                    if (preparedStatementSetter != null) {
                        preparedStatementSetter.setValues(preparedStatement);
                    }
                    int n = preparedStatement.executeUpdate();
                    if (JdbcTemplate.this.logger.isDebugEnabled()) {
                        JdbcTemplate.this.logger.debug((Object)("SQL update affected " + n + " rows"));
                    }
                    Integer n2 = new Integer(n);
                    return n2;
                }
                finally {
                    if (preparedStatementSetter instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)preparedStatementSetter)).cleanupParameters();
                    }
                }
            }
        });
        return n;
    }

    public int update(PreparedStatementCreator preparedStatementCreator) throws DataAccessException {
        return this.update(preparedStatementCreator, (PreparedStatementSetter)null);
    }

    public int update(PreparedStatementCreator preparedStatementCreator, final KeyHolder keyHolder) throws DataAccessException {
        Assert.notNull((Object)keyHolder, (String)"KeyHolder must not be null");
        this.logger.debug((Object)"Executing SQL update and returning generated keys");
        Integer n = (Integer)this.execute(preparedStatementCreator, new PreparedStatementCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInPreparedStatement(PreparedStatement preparedStatement) throws SQLException {
                int n = preparedStatement.executeUpdate();
                List list = keyHolder.getKeyList();
                list.clear();
                ResultSet resultSet = preparedStatement.getGeneratedKeys();
                if (resultSet != null) {
                    try {
                        RowMapper rowMapper = JdbcTemplate.this.getColumnMapRowMapper();
                        RowMapperResultSetExtractor rowMapperResultSetExtractor = new RowMapperResultSetExtractor(rowMapper, 1);
                        list.addAll((List)rowMapperResultSetExtractor.extractData(resultSet));
                    }
                    finally {
                        JdbcUtils.closeResultSet(resultSet);
                    }
                }
                if (JdbcTemplate.this.logger.isDebugEnabled()) {
                    JdbcTemplate.this.logger.debug((Object)("SQL update affected " + n + " rows and returned " + list.size() + " keys"));
                }
                return new Integer(n);
            }
        });
        return n;
    }

    public int update(String string, PreparedStatementSetter preparedStatementSetter) throws DataAccessException {
        return this.update((PreparedStatementCreator)new SimplePreparedStatementCreator(string), preparedStatementSetter);
    }

    public int update(String string, Object[] objectArray, int[] nArray) throws DataAccessException {
        return this.update(string, (PreparedStatementSetter)new ArgTypePreparedStatementSetter(objectArray, nArray));
    }

    public int update(String string, Object[] objectArray) throws DataAccessException {
        return this.update(string, (PreparedStatementSetter)new ArgPreparedStatementSetter(objectArray));
    }

    public int[] batchUpdate(String string, final BatchPreparedStatementSetter batchPreparedStatementSetter) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing SQL batch update [" + string + "]"));
        }
        return (int[])this.execute(string, new PreparedStatementCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInPreparedStatement(PreparedStatement preparedStatement) throws SQLException {
                try {
                    InterruptibleBatchPreparedStatementSetter interruptibleBatchPreparedStatementSetter;
                    int n = batchPreparedStatementSetter.getBatchSize();
                    InterruptibleBatchPreparedStatementSetter interruptibleBatchPreparedStatementSetter2 = interruptibleBatchPreparedStatementSetter = batchPreparedStatementSetter instanceof InterruptibleBatchPreparedStatementSetter ? (InterruptibleBatchPreparedStatementSetter)batchPreparedStatementSetter : null;
                    if (JdbcUtils.supportsBatchUpdates(preparedStatement.getConnection())) {
                        for (int i = 0; i < n; ++i) {
                            batchPreparedStatementSetter.setValues(preparedStatement, i);
                            if (interruptibleBatchPreparedStatementSetter != null && interruptibleBatchPreparedStatementSetter.isBatchExhausted(i)) break;
                            preparedStatement.addBatch();
                        }
                        int[] nArray = preparedStatement.executeBatch();
                        return nArray;
                    }
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (int i = 0; i < n; ++i) {
                        batchPreparedStatementSetter.setValues(preparedStatement, i);
                        if (interruptibleBatchPreparedStatementSetter != null && interruptibleBatchPreparedStatementSetter.isBatchExhausted(i)) break;
                        arrayList.add(new Integer(preparedStatement.executeUpdate()));
                    }
                    int[] nArray = new int[arrayList.size()];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = (Integer)arrayList.get(i);
                    }
                    int[] nArray2 = nArray;
                    return nArray2;
                }
                finally {
                    if (batchPreparedStatementSetter instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)batchPreparedStatementSetter)).cleanupParameters();
                    }
                }
            }
        });
    }

    public Object execute(CallableStatementCreator callableStatementCreator, CallableStatementCallback callableStatementCallback) throws DataAccessException {
        Object object;
        Object object2;
        Assert.notNull((Object)callableStatementCreator, (String)"CallableStatementCreator must not be null");
        Assert.notNull((Object)callableStatementCallback, (String)"Callback object must not be null");
        if (this.logger.isDebugEnabled()) {
            object2 = JdbcTemplate.getSql(callableStatementCreator);
            this.logger.debug((Object)("Calling stored procedure" + (object2 != null ? " [" + (String)object2 + "]" : "")));
        }
        object2 = DataSourceUtils.getConnection(this.getDataSource());
        CallableStatement callableStatement = null;
        try {
            Object object3 = object2;
            if (this.nativeJdbcExtractor != null) {
                object3 = this.nativeJdbcExtractor.getNativeConnection((Connection)object2);
            }
            callableStatement = callableStatementCreator.createCallableStatement((Connection)object3);
            this.applyStatementSettings(callableStatement);
            CallableStatement callableStatement2 = callableStatement;
            if (this.nativeJdbcExtractor != null) {
                callableStatement2 = this.nativeJdbcExtractor.getNativeCallableStatement(callableStatement);
            }
            Object object4 = callableStatementCallback.doInCallableStatement(callableStatement2);
            this.handleWarnings(callableStatement.getWarnings());
            object = object4;
        }
        catch (SQLException sQLException) {
            try {
                if (callableStatementCreator instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)callableStatementCreator)).cleanupParameters();
                }
                String string = JdbcTemplate.getSql(callableStatementCreator);
                callableStatementCreator = null;
                JdbcUtils.closeStatement(callableStatement);
                callableStatement = null;
                DataSourceUtils.releaseConnection((Connection)object2, this.getDataSource());
                object2 = null;
                throw this.getExceptionTranslator().translate("CallableStatementCallback", string, sQLException);
            }
            catch (Throwable throwable) {
                if (callableStatementCreator instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)callableStatementCreator)).cleanupParameters();
                }
                JdbcUtils.closeStatement(callableStatement);
                DataSourceUtils.releaseConnection((Connection)object2, this.getDataSource());
                throw throwable;
            }
        }
        if (callableStatementCreator instanceof ParameterDisposer) {
            ((ParameterDisposer)((Object)callableStatementCreator)).cleanupParameters();
        }
        JdbcUtils.closeStatement(callableStatement);
        DataSourceUtils.releaseConnection((Connection)object2, this.getDataSource());
        return object;
    }

    public Object execute(String string, CallableStatementCallback callableStatementCallback) throws DataAccessException {
        return this.execute(new SimpleCallableStatementCreator(string), callableStatementCallback);
    }

    public Map call(CallableStatementCreator callableStatementCreator, final List list) throws DataAccessException {
        return (Map)this.execute(callableStatementCreator, new CallableStatementCallback(){

            public Object doInCallableStatement(CallableStatement callableStatement) throws SQLException {
                boolean bl = callableStatement.execute();
                int n = callableStatement.getUpdateCount();
                if (JdbcTemplate.this.logger.isDebugEnabled()) {
                    JdbcTemplate.this.logger.debug((Object)("CallableStatement.execute() returned '" + bl + "'"));
                    JdbcTemplate.this.logger.debug((Object)("CallableStatement.getUpdateCount() returned " + n));
                }
                HashMap hashMap = new HashMap();
                if (bl || n != -1) {
                    hashMap.putAll(JdbcTemplate.this.extractReturnedResultSets(callableStatement, list, n));
                }
                hashMap.putAll(JdbcTemplate.this.extractOutputParameters(callableStatement, list));
                return hashMap;
            }
        });
    }

    protected Map extractReturnedResultSets(CallableStatement callableStatement, List list, int n) throws SQLException {
        HashMap hashMap = new HashMap();
        int n2 = 0;
        if (!this.skipResultsProcessing) {
            boolean bl;
            do {
                if (n == -1) {
                    Object var7_7 = null;
                    if (list != null && list.size() > n2) {
                        var7_7 = list.get(n2);
                    }
                    if (var7_7 instanceof SqlReturnResultSet) {
                        SqlReturnResultSet sqlReturnResultSet = var7_7;
                        hashMap.putAll(this.processResultSet(callableStatement.getResultSet(), sqlReturnResultSet));
                    } else {
                        this.logger.warn((Object)"Results returned from stored procedure but a corresponding SqlOutParameter/SqlReturnResultSet parameter was not declared");
                    }
                    ++n2;
                }
                bl = callableStatement.getMoreResults();
                n = callableStatement.getUpdateCount();
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("CallableStatement.getUpdateCount() returned " + n));
            } while (bl || n != -1);
        }
        return hashMap;
    }

    protected Map extractOutputParameters(CallableStatement callableStatement, List list) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = 1;
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof SqlOutParameter) {
                Object object;
                SqlOutParameter sqlOutParameter = (SqlOutParameter)e;
                if (sqlOutParameter.isReturnTypeSupported()) {
                    object = sqlOutParameter.getSqlReturnType().getTypeValue(callableStatement, n, sqlOutParameter.getSqlType(), sqlOutParameter.getTypeName());
                    hashMap.put(sqlOutParameter.getName(), object);
                } else {
                    object = callableStatement.getObject(n);
                    if (object instanceof ResultSet) {
                        if (sqlOutParameter.isResultSetSupported()) {
                            hashMap.putAll(this.processResultSet((ResultSet)object, sqlOutParameter));
                        } else {
                            this.logger.warn((Object)"ResultSet returned from stored procedure but no corresponding SqlOutParameter with a ResultSetExtractor/RowCallbackHandler/RowMapper declared");
                            hashMap.put(sqlOutParameter.getName(), "ResultSet was returned but not processed");
                        }
                    } else {
                        hashMap.put(sqlOutParameter.getName(), object);
                    }
                }
            }
            if (e instanceof SqlReturnResultSet) continue;
            ++n;
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map processResultSet(ResultSet resultSet, ResultSetSupportingSqlParameter resultSetSupportingSqlParameter) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            ResultSet resultSet2 = resultSet;
            if (this.nativeJdbcExtractor != null) {
                resultSet2 = this.nativeJdbcExtractor.getNativeResultSet(resultSet);
            }
            if (resultSetSupportingSqlParameter.getRowMapper() != null) {
                RowMapper rowMapper = resultSetSupportingSqlParameter.getRowMapper();
                Object object = new RowMapperResultSetExtractor(rowMapper).extractData(resultSet2);
                hashMap.put(resultSetSupportingSqlParameter.getName(), object);
            } else if (resultSetSupportingSqlParameter.getRowCallbackHandler() != null) {
                RowCallbackHandler rowCallbackHandler = resultSetSupportingSqlParameter.getRowCallbackHandler();
                new RowCallbackHandlerResultSetExtractor(rowCallbackHandler).extractData(resultSet2);
                hashMap.put(resultSetSupportingSqlParameter.getName(), "ResultSet returned from stored procedure was processed");
            } else if (resultSetSupportingSqlParameter.getResultSetExtractor() != null) {
                Object object = resultSetSupportingSqlParameter.getResultSetExtractor().extractData(resultSet2);
                hashMap.put(resultSetSupportingSqlParameter.getName(), object);
            }
        }
        finally {
            JdbcUtils.closeResultSet(resultSet);
        }
        return hashMap;
    }

    protected RowMapper getColumnMapRowMapper() {
        return new ColumnMapRowMapper();
    }

    protected RowMapper getSingleColumnRowMapper(Class clazz) {
        return new SingleColumnRowMapper(clazz);
    }

    protected void applyStatementSettings(Statement statement) throws SQLException {
        int n;
        int n2 = this.getFetchSize();
        if (n2 > 0) {
            statement.setFetchSize(n2);
        }
        if ((n = this.getMaxRows()) > 0) {
            statement.setMaxRows(n);
        }
        DataSourceUtils.applyTimeout(statement, this.getDataSource(), this.getQueryTimeout());
    }

    protected void handleWarnings(SQLWarning sQLWarning) throws SQLWarningException {
        if (sQLWarning != null) {
            if (this.isIgnoreWarnings()) {
                if (this.logger.isDebugEnabled()) {
                    for (SQLWarning sQLWarning2 = sQLWarning; sQLWarning2 != null; sQLWarning2 = sQLWarning2.getNextWarning()) {
                        this.logger.debug((Object)("SQLWarning ignored: SQL state '" + sQLWarning2.getSQLState() + "', error code '" + sQLWarning2.getErrorCode() + "', message [" + sQLWarning2.getMessage() + "]"));
                    }
                }
            } else {
                throw new SQLWarningException("Warning not ignored", sQLWarning);
            }
        }
    }

    private static String getSql(Object object) {
        if (object instanceof SqlProvider) {
            return ((SqlProvider)object).getSql();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public CloseSuppressingInvocationHandler(Connection connection) {
            this.target = connection;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            if (method.getName().equals("equals")) {
                return object == objectArray[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object object2 = method.invoke((Object)this.target, objectArray);
                if (object2 instanceof Statement) {
                    JdbcTemplate.this.applyStatementSettings((Statement)object2);
                }
                return object2;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
    }

    private static class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor {
        private final RowCallbackHandler rch;

        public RowCallbackHandlerResultSetExtractor(RowCallbackHandler rowCallbackHandler) {
            this.rch = rowCallbackHandler;
        }

        public Object extractData(ResultSet resultSet) throws SQLException {
            while (resultSet.next()) {
                this.rch.processRow(resultSet);
            }
            return null;
        }
    }

    private static class SimpleCallableStatementCreator
    implements CallableStatementCreator,
    SqlProvider {
        private final String callString;

        public SimpleCallableStatementCreator(String string) {
            Assert.notNull((Object)string, (String)"Call string must not be null");
            this.callString = string;
        }

        public CallableStatement createCallableStatement(Connection connection) throws SQLException {
            return connection.prepareCall(this.callString);
        }

        public String getSql() {
            return this.callString;
        }
    }

    private static class SimplePreparedStatementCreator
    implements PreparedStatementCreator,
    SqlProvider {
        private final String sql;

        public SimplePreparedStatementCreator(String string) {
            Assert.notNull((Object)string, (String)"SQL must not be null");
            this.sql = string;
        }

        public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(this.sql);
        }

        public String getSql() {
            return this.sql;
        }
    }
}

