/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.ParameterMapper;
import org.springframework.jdbc.core.ResultSetSupportingSqlParameter;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.jdbc.core.SqlReturnResultSet;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

public class CallableStatementCreatorFactory {
    private final String callString;
    private final List declaredParameters;
    private int resultSetType = 1003;
    private boolean updatableResults = false;
    private NativeJdbcExtractor nativeJdbcExtractor;

    public CallableStatementCreatorFactory(String string) {
        this.callString = string;
        this.declaredParameters = new LinkedList();
    }

    public CallableStatementCreatorFactory(String string, List list) {
        this.callString = string;
        this.declaredParameters = list;
    }

    public void addParameter(SqlParameter sqlParameter) {
        this.declaredParameters.add(sqlParameter);
    }

    public void setResultSetType(int n) {
        this.resultSetType = n;
    }

    public void setUpdatableResults(boolean bl) {
        this.updatableResults = bl;
    }

    public void setNativeJdbcExtractor(NativeJdbcExtractor nativeJdbcExtractor) {
        this.nativeJdbcExtractor = nativeJdbcExtractor;
    }

    public CallableStatementCreator newCallableStatementCreator(Map map) {
        return new CallableStatementCreatorImpl(map != null ? map : new HashMap());
    }

    public CallableStatementCreator newCallableStatementCreator(ParameterMapper parameterMapper) {
        return new CallableStatementCreatorImpl(parameterMapper);
    }

    private class CallableStatementCreatorImpl
    implements CallableStatementCreator,
    SqlProvider,
    ParameterDisposer {
        private ParameterMapper inParameterMapper;
        private Map inParameters;

        public CallableStatementCreatorImpl(ParameterMapper parameterMapper) {
            this.inParameterMapper = parameterMapper;
        }

        public CallableStatementCreatorImpl(Map map) {
            this.inParameters = map;
        }

        public CallableStatement createCallableStatement(Connection connection) throws SQLException {
            if (this.inParameterMapper != null) {
                this.inParameters = this.inParameterMapper.createMap(connection);
            } else if (this.inParameters == null) {
                throw new InvalidDataAccessApiUsageException("A ParameterMapper or a Map of parameters must be provided");
            }
            CallableStatement callableStatement = null;
            callableStatement = CallableStatementCreatorFactory.this.resultSetType == 1003 && !CallableStatementCreatorFactory.this.updatableResults ? connection.prepareCall(CallableStatementCreatorFactory.this.callString) : connection.prepareCall(CallableStatementCreatorFactory.this.callString, CallableStatementCreatorFactory.this.resultSetType, CallableStatementCreatorFactory.this.updatableResults ? 1008 : 1007);
            CallableStatement callableStatement2 = callableStatement;
            if (CallableStatementCreatorFactory.this.nativeJdbcExtractor != null) {
                callableStatement2 = CallableStatementCreatorFactory.this.nativeJdbcExtractor.getNativeCallableStatement(callableStatement);
            }
            int n = 1;
            for (int i = 0; i < CallableStatementCreatorFactory.this.declaredParameters.size(); ++i) {
                SqlParameter sqlParameter = (SqlParameter)CallableStatementCreatorFactory.this.declaredParameters.get(i);
                if (!this.inParameters.containsKey(sqlParameter.getName()) && !(sqlParameter instanceof ResultSetSupportingSqlParameter)) {
                    throw new InvalidDataAccessApiUsageException("Required input parameter '" + sqlParameter.getName() + "' is missing");
                }
                Object v = this.inParameters.get(sqlParameter.getName());
                if (!(sqlParameter instanceof ResultSetSupportingSqlParameter)) {
                    StatementCreatorUtils.setParameterValue((PreparedStatement)callableStatement2, n, sqlParameter, v);
                } else if (sqlParameter instanceof SqlOutParameter) {
                    if (sqlParameter.getTypeName() != null) {
                        callableStatement.registerOutParameter(n, sqlParameter.getSqlType(), sqlParameter.getTypeName());
                    } else {
                        callableStatement.registerOutParameter(n, sqlParameter.getSqlType());
                    }
                    if (((SqlOutParameter)sqlParameter).isInputValueProvided() || v != null) {
                        StatementCreatorUtils.setParameterValue((PreparedStatement)callableStatement2, n, sqlParameter, v);
                    }
                }
                if (sqlParameter instanceof SqlReturnResultSet) continue;
                ++n;
            }
            return callableStatement;
        }

        public String getSql() {
            return CallableStatementCreatorFactory.this.callString;
        }

        public void cleanupParameters() {
            if (this.inParameters != null) {
                StatementCreatorUtils.cleanupParameters(this.inParameters.values());
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("CallableStatementCreatorFactory.CallableStatementCreatorImpl: sql=[");
            stringBuffer.append(CallableStatementCreatorFactory.this.callString).append("]; parameters=").append(this.inParameters);
            return stringBuffer.toString();
        }
    }
}

