/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.StatementCreatorUtils;

class ArgTypePreparedStatementSetter
implements PreparedStatementSetter,
ParameterDisposer {
    private final Object[] args;
    private final int[] argTypes;

    public ArgTypePreparedStatementSetter(Object[] objectArray, int[] nArray) {
        if (objectArray != null && nArray == null || objectArray == null && nArray != null || objectArray != null && objectArray.length != nArray.length) {
            throw new InvalidDataAccessApiUsageException("args and argTypes parameters must match");
        }
        this.args = objectArray;
        this.argTypes = nArray;
    }

    public void setValues(PreparedStatement preparedStatement) throws SQLException {
        int n = 1;
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                Object object = this.args[i];
                if (object instanceof Collection && this.argTypes[i] != 2003) {
                    Collection collection = (Collection)object;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        StatementCreatorUtils.setParameterValue(preparedStatement, n++, this.argTypes[i], e);
                    }
                    continue;
                }
                StatementCreatorUtils.setParameterValue(preparedStatement, n++, this.argTypes[i], object);
            }
        }
    }

    public void cleanupParameters() {
        StatementCreatorUtils.cleanupParameters(this.args);
    }
}

