/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.StatementCreatorUtils;

class ArgPreparedStatementSetter
implements PreparedStatementSetter,
ParameterDisposer {
    private final Object[] args;

    public ArgPreparedStatementSetter(Object[] objectArray) {
        this.args = objectArray;
    }

    public void setValues(PreparedStatement preparedStatement) throws SQLException {
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                Object object = this.args[i];
                if (object instanceof SqlParameterValue) {
                    SqlParameterValue sqlParameterValue = (SqlParameterValue)object;
                    StatementCreatorUtils.setParameterValue(preparedStatement, i + 1, sqlParameterValue, sqlParameterValue.getValue());
                    continue;
                }
                StatementCreatorUtils.setParameterValue(preparedStatement, i + 1, Integer.MIN_VALUE, object);
            }
        }
    }

    public void cleanupParameters() {
        StatementCreatorUtils.cleanupParameters(this.args);
    }
}

