/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.OgnlUtil;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.components.Component;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

@StrutsTag(name="bean", tldTagClass="org.apache.struts2.views.jsp.BeanTag", description="Instantiate a JavaBean and place it in the context")
public class Bean
extends Component {
    protected static Log log = LogFactory.getLog(Bean.class);
    protected Object bean;
    protected String name;
    protected ObjectFactory objectFactory;

    public Bean(ValueStack stack) {
        super(stack);
    }

    @Inject
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public boolean start(Writer writer) {
        boolean result = super.start(writer);
        ValueStack stack = this.getStack();
        try {
            String beanName = this.findString(this.name, "name", "Bean name is required. Example: com.acme.FooBean");
            this.bean = this.objectFactory.buildBean(ClassLoaderUtil.loadClass((String)beanName, this.getClass()), stack.getContext());
        }
        catch (Exception e) {
            log.error((Object)"Could not instantiate bean", (Throwable)e);
            return false;
        }
        stack.push(this.bean);
        if (this.getId() != null) {
            this.getStack().getContext().put(this.getId(), this.bean);
        }
        return result;
    }

    public boolean end(Writer writer, String body) {
        ValueStack stack = this.getStack();
        stack.pop();
        return super.end(writer, body);
    }

    public void addParameter(String key, Object value) {
        OgnlUtil.setProperty((String)key, (Object)value, (Object)this.bean, (Map)this.getStack().getContext());
    }

    @StrutsTagAttribute(description="The class name of the bean to be instantiated (must respect JavaBean specification)", required=true)
    public void setName(String name) {
        this.name = name;
    }
}

