/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.transform.impl;

import java.lang.reflect.Method;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.transform.ClassEmitterTransformer;
import org.objectweb.asm.Type;

public class AddStaticInitTransformer
extends ClassEmitterTransformer {
    private MethodInfo info;

    public AddStaticInitTransformer(Method method) {
        this.info = ReflectUtils.getMethodInfo(method);
        if (!TypeUtils.isStatic(this.info.getModifiers())) {
            throw new IllegalArgumentException(method + " is not static");
        }
        Type[] typeArray = this.info.getSignature().getArgumentTypes();
        if (typeArray.length != 1 || !typeArray[0].equals((Object)Constants.TYPE_CLASS) || !this.info.getSignature().getReturnType().equals((Object)Type.VOID_TYPE)) {
            throw new IllegalArgumentException(method + " illegal signature");
        }
    }

    protected void init() {
        if (!TypeUtils.isInterface(this.getAccess())) {
            CodeEmitter codeEmitter = this.getStaticHook();
            EmitUtils.load_class_this(codeEmitter);
            codeEmitter.invoke(this.info);
        }
    }
}

