/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.transform.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.transform.ClassEmitterTransformer;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Type;

public class AddDelegateTransformer
extends ClassEmitterTransformer {
    private static final String DELEGATE = "$CGLIB_DELEGATE";
    private static final Signature CSTRUCT_OBJECT = TypeUtils.parseSignature("void <init>(Object)");
    private Class[] delegateIf;
    private Class delegateImpl;
    private Type delegateType;
    static /* synthetic */ Class class$java$lang$Object;

    public AddDelegateTransformer(Class[] classArray, Class clazz) {
        try {
            clazz.getConstructor(class$java$lang$Object == null ? (class$java$lang$Object = AddDelegateTransformer.class$("java.lang.Object")) : class$java$lang$Object);
            this.delegateIf = classArray;
            this.delegateImpl = clazz;
            this.delegateType = Type.getType((Class)clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CodeGenerationException(noSuchMethodException);
        }
    }

    public void begin_class(int n, int n2, String string, Type type, Type[] typeArray, String string2) {
        if (!TypeUtils.isInterface(n2)) {
            Type[] typeArray2 = TypeUtils.add(typeArray, TypeUtils.getTypes(this.delegateIf));
            super.begin_class(n, n2, string, type, typeArray2, string2);
            this.declare_field(130, DELEGATE, this.delegateType, null, null);
            for (int i = 0; i < this.delegateIf.length; ++i) {
                Method[] methodArray = this.delegateIf[i].getMethods();
                for (int j = 0; j < methodArray.length; ++j) {
                    if (!Modifier.isAbstract(methodArray[j].getModifiers())) continue;
                    this.addDelegate(methodArray[j]);
                }
            }
        } else {
            super.begin_class(n, n2, string, type, typeArray, string2);
        }
    }

    public CodeEmitter begin_method(int n, Signature signature, Type[] typeArray, Attribute attribute) {
        CodeEmitter codeEmitter = super.begin_method(n, signature, typeArray, attribute);
        if (signature.getName().equals("<init>")) {
            return new CodeEmitter(codeEmitter){
                private boolean transformInit = true;

                public void visitMethodInsn(int n, String string, String string2, String string3) {
                    super.visitMethodInsn(n, string, string2, string3);
                    if (this.transformInit && n == 183) {
                        this.load_this();
                        this.new_instance(AddDelegateTransformer.this.delegateType);
                        this.dup();
                        this.load_this();
                        this.invoke_constructor(AddDelegateTransformer.this.delegateType, CSTRUCT_OBJECT);
                        this.putfield(AddDelegateTransformer.DELEGATE);
                        this.transformInit = false;
                    }
                }
            };
        }
        return codeEmitter;
    }

    private void addDelegate(Method method) {
        try {
            Method method2 = this.delegateImpl.getMethod(method.getName(), method.getParameterTypes());
            if (!method2.getReturnType().getName().equals(method.getReturnType().getName())) {
                throw new IllegalArgumentException("Invalid delegate signature " + method2);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CodeGenerationException(noSuchMethodException);
        }
        Signature signature = ReflectUtils.getSignature(method);
        Type[] typeArray = TypeUtils.getTypes(method.getExceptionTypes());
        CodeEmitter codeEmitter = super.begin_method(1, signature, typeArray, null);
        codeEmitter.load_this();
        codeEmitter.getfield(DELEGATE);
        codeEmitter.load_args();
        codeEmitter.invoke_virtual(this.delegateType, signature);
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

