/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.transform.hook;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.cglib.core.RemappingCodeVisitor;
import org.codehaus.aspectwerkz.hook.ClassLoaderPatcher;
import org.codehaus.aspectwerkz.hook.ClassLoaderPreProcessor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Type;

public class AsmClassLoaderPreProcessor
implements ClassLoaderPreProcessor {
    private static final String DESC_CORE = "Ljava/lang/String;[BIILjava/security/ProtectionDomain;";
    private static final String DESC_PREFIX = "(Ljava/lang/String;[BIILjava/security/ProtectionDomain;";
    private static final String DESC_HELPER = "(Ljava/lang/ClassLoader;Ljava/lang/String;[BIILjava/security/ProtectionDomain;)[B";

    public byte[] preProcess(byte[] byArray) {
        try {
            ClassWriter classWriter = new ClassWriter(true){
                private boolean flag;

                public void visit(int n, int n2, String string, String string2, String[] stringArray, String string3) {
                    super.visit(n, n2, string, string2, stringArray, string3);
                    this.flag = string.equals("java/lang/ClassLoader");
                }

                public CodeVisitor visitMethod(int n, String string, String string2, String[] stringArray, Attribute attribute) {
                    Object object = super.visitMethod(n, string, string2, stringArray, attribute);
                    if (this.flag) {
                        object = new PreProcessingVisitor((CodeVisitor)object, n, string2);
                    }
                    return object;
                }
            };
            new ClassReader(byArray).accept((ClassVisitor)classWriter, false);
            return classWriter.toByteArray();
        }
        catch (Exception exception) {
            System.err.println("failed to patch ClassLoader:");
            exception.printStackTrace();
            return byArray;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        AsmClassLoaderPreProcessor asmClassLoaderPreProcessor = new AsmClassLoaderPreProcessor();
        InputStream inputStream = ClassLoader.getSystemClassLoader().getParent().getResourceAsStream("java/lang/ClassLoader.class");
        byte[] byArray = asmClassLoaderPreProcessor.preProcess(ClassLoaderPatcher.inputStreamToByteArray((InputStream)inputStream));
        inputStream.close();
        FileOutputStream fileOutputStream = new FileOutputStream("_boot/java/lang/ClassLoader.class");
        ((OutputStream)fileOutputStream).write(byArray);
        ((OutputStream)fileOutputStream).close();
    }

    private static class PreProcessingVisitor
    extends RemappingCodeVisitor {
        public PreProcessingVisitor(CodeVisitor codeVisitor, int n, String string) {
            super(codeVisitor, n, Type.getArgumentTypes((String)string));
        }

        public void visitMethodInsn(int n, String string, String string2, String string3) {
            if ("defineClass0".equals(string2) && "java/lang/ClassLoader".equals(string)) {
                int n2;
                Type[] typeArray = Type.getArgumentTypes((String)string3);
                if (typeArray.length < 5 || !string3.startsWith(AsmClassLoaderPreProcessor.DESC_PREFIX)) {
                    throw new Error("non standard JDK, native call not supported: " + string3);
                }
                int[] nArray = new int[typeArray.length];
                for (n2 = typeArray.length - 1; n2 >= 0; --n2) {
                    nArray[n2] = this.nextLocal(typeArray[n2].getSize());
                    this.cv.visitVarInsn(typeArray[n2].getOpcode(54), nArray[n2]);
                }
                for (n2 = 0; n2 < 5; ++n2) {
                    this.cv.visitVarInsn(typeArray[n2].getOpcode(21), nArray[n2]);
                }
                super.visitMethodInsn(184, "org/codehaus/aspectwerkz/hook/impl/ClassPreProcessorHelper", "defineClass0Pre", AsmClassLoaderPreProcessor.DESC_HELPER);
                this.cv.visitVarInsn(58, nArray[1]);
                this.cv.visitVarInsn(25, 0);
                this.cv.visitVarInsn(25, nArray[0]);
                this.cv.visitVarInsn(25, nArray[1]);
                this.cv.visitInsn(3);
                this.cv.visitVarInsn(25, nArray[1]);
                this.cv.visitInsn(190);
                this.cv.visitVarInsn(25, nArray[4]);
                for (n2 = 5; n2 < typeArray.length; ++n2) {
                    this.cv.visitVarInsn(typeArray[n2].getOpcode(21), nArray[n2]);
                }
            }
            super.visitMethodInsn(n, string, string2, string3);
        }
    }
}

