/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.transform;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sf.cglib.core.ClassNameReader;
import net.sf.cglib.core.DebuggingClassWriter;
import net.sf.cglib.transform.AbstractProcessTask;
import net.sf.cglib.transform.ClassReaderGenerator;
import net.sf.cglib.transform.ClassTransformer;
import net.sf.cglib.transform.TransformingClassGenerator;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.attrs.Attributes;

public abstract class AbstractTransformTask
extends AbstractProcessTask {
    private static final int ZIP_MAGIC = 1347093252;
    private static final int CLASS_MAGIC = -889275714;
    private boolean verbose;

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    protected abstract ClassTransformer getClassTransformer(String[] var1);

    protected Attribute[] attributes() {
        return Attributes.getDefaultAttributes();
    }

    protected void processFile(File file) throws Exception {
        if (this.isClassFile(file)) {
            this.processClassFile(file);
        } else if (this.isJarFile(file)) {
            this.processJarFile(file);
        } else {
            this.log("ignoring " + file.toURL(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClassFile(File file) throws Exception, FileNotFoundException, IOException, MalformedURLException {
        ClassReader classReader = AbstractTransformTask.getClassReader(file);
        String[] stringArray = ClassNameReader.getClassInfo(classReader);
        DebuggingClassWriter debuggingClassWriter = new DebuggingClassWriter(true);
        ClassTransformer classTransformer = this.getClassTransformer(stringArray);
        if (classTransformer != null) {
            if (this.verbose) {
                this.log("processing " + file.toURL());
            }
            new TransformingClassGenerator(new ClassReaderGenerator(AbstractTransformTask.getClassReader(file), this.attributes(), this.skipDebug()), classTransformer).generateClass((ClassVisitor)debuggingClassWriter);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                fileOutputStream.write(debuggingClassWriter.toByteArray());
            }
            finally {
                fileOutputStream.close();
            }
        }
    }

    protected boolean skipDebug() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassReader getClassReader(File file) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            ClassReader classReader;
            ClassReader classReader2 = classReader = new ClassReader((InputStream)bufferedInputStream);
            return classReader2;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    protected boolean isClassFile(File file) throws IOException {
        return this.checkMagic(file, -889275714L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJarFile(File file) throws Exception {
        block19: {
            if (this.verbose) {
                this.log("processing " + file.toURL());
            }
            File file2 = File.createTempFile(file.getName(), null, new File(file.getAbsoluteFile().getParent()));
            try {
                Object object;
                ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
                try {
                    object = new FileOutputStream(file2, false);
                    try {
                        ZipEntry zipEntry;
                        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)object);
                        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                            Object object2;
                            byte[] byArray = this.getBytes(zipInputStream);
                            if (!zipEntry.isDirectory()) {
                                object2 = new DataInputStream(new ByteArrayInputStream(byArray));
                                if (((DataInputStream)object2).readInt() == -889275714) {
                                    byArray = this.process(byArray);
                                } else if (this.verbose) {
                                    this.log("ignoring " + zipEntry.toString());
                                }
                            }
                            object2 = new ZipEntry(zipEntry.getName());
                            ((ZipEntry)object2).setMethod(zipEntry.getMethod());
                            ((ZipEntry)object2).setComment(zipEntry.getComment());
                            ((ZipEntry)object2).setSize(byArray.length);
                            if (((ZipEntry)object2).getMethod() == 0) {
                                CRC32 cRC32 = new CRC32();
                                cRC32.update(byArray);
                                ((ZipEntry)object2).setCrc(cRC32.getValue());
                                ((ZipEntry)object2).setCompressedSize(byArray.length);
                            }
                            zipOutputStream.putNextEntry((ZipEntry)object2);
                            zipOutputStream.write(byArray);
                            zipOutputStream.closeEntry();
                            zipInputStream.closeEntry();
                        }
                        zipOutputStream.close();
                    }
                    finally {
                        ((FileOutputStream)object).close();
                    }
                }
                finally {
                    zipInputStream.close();
                }
                if (file.delete()) {
                    object = new File(file2.getAbsolutePath());
                    if (!((File)object).renameTo(file)) {
                        throw new IOException("can not rename " + file2 + " to " + file);
                    }
                    break block19;
                }
                throw new IOException("can not delete " + file);
            }
            finally {
                file2.delete();
            }
        }
    }

    private byte[] process(byte[] byArray) throws Exception {
        ClassReader classReader = new ClassReader((InputStream)new ByteArrayInputStream(byArray));
        String[] stringArray = ClassNameReader.getClassInfo(classReader);
        DebuggingClassWriter debuggingClassWriter = new DebuggingClassWriter(true);
        ClassTransformer classTransformer = this.getClassTransformer(stringArray);
        if (classTransformer != null) {
            if (this.verbose) {
                this.log("processing " + stringArray[0]);
            }
            new TransformingClassGenerator(new ClassReaderGenerator(new ClassReader((InputStream)new ByteArrayInputStream(byArray)), this.attributes(), this.skipDebug()), classTransformer).generateClass((ClassVisitor)debuggingClassWriter);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(debuggingClassWriter.toByteArray());
            return byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private byte[] getBytes(ZipInputStream zipInputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(zipInputStream);
        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMagic(File file, long l) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        try {
            int n = dataInputStream.readInt();
            boolean bl = l == (long)n;
            return bl;
        }
        finally {
            dataInputStream.close();
        }
    }

    protected boolean isJarFile(File file) throws IOException {
        return this.checkMagic(file, 1347093252L);
    }
}

