/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.transform;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import net.sf.cglib.core.ClassGenerator;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.DebuggingClassWriter;
import net.sf.cglib.transform.ClassFilter;
import net.sf.cglib.transform.ClassReaderGenerator;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.attrs.Attributes;

public abstract class AbstractClassLoader
extends ClassLoader {
    private ClassFilter filter;
    private ClassLoader classPath;
    private static ProtectionDomain DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return (class$net$sf$cglib$transform$AbstractClassLoader == null ? (class$net$sf$cglib$transform$AbstractClassLoader = AbstractClassLoader.class$("net.sf.cglib.transform.AbstractClassLoader")) : class$net$sf$cglib$transform$AbstractClassLoader).getProtectionDomain();
        }
    });
    static /* synthetic */ Class class$net$sf$cglib$transform$AbstractClassLoader;

    protected AbstractClassLoader(ClassLoader classLoader, ClassLoader classLoader2, ClassFilter classFilter) {
        super(classLoader);
        this.filter = classFilter;
        this.classPath = classLoader2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String string) throws ClassNotFoundException {
        ClassReader classReader;
        Object object;
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null && clazz.getClassLoader() == this) {
            return clazz;
        }
        if (!this.filter.accept(string)) {
            return super.loadClass(string);
        }
        try {
            object = this.classPath.getResourceAsStream(string.replace('.', '/') + ".class");
            if (object == null) {
                throw new ClassNotFoundException(string);
            }
            try {
                classReader = new ClassReader(object);
            }
            finally {
                object.close();
            }
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string + ":" + iOException.getMessage());
        }
        try {
            object = new DebuggingClassWriter(true);
            this.getGenerator(classReader).generateClass((ClassVisitor)object);
            byte[] byArray = object.toByteArray();
            Class<?> clazz2 = super.defineClass(string, byArray, 0, byArray.length, DOMAIN);
            this.postProcess(clazz2);
            return clazz2;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Exception exception) {
            throw new CodeGenerationException(exception);
        }
    }

    protected ClassGenerator getGenerator(ClassReader classReader) {
        return new ClassReaderGenerator(classReader, this.attributes(), this.skipDebug());
    }

    protected boolean skipDebug() {
        return false;
    }

    protected Attribute[] attributes() {
        return Attributes.getDefaultAttributes();
    }

    protected void postProcess(Class clazz) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

