/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.cglib.core.Block;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.DuplicatesPredicate;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.MethodInfoTransformer;
import net.sf.cglib.core.ObjectSwitchCallback;
import net.sf.cglib.core.ProcessSwitchCallback;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.Transformer;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.core.VisibilityPredicate;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

class FastClassEmitter
extends ClassEmitter {
    private static final Signature CSTRUCT_CLASS = TypeUtils.parseConstructor("Class");
    private static final Signature METHOD_GET_INDEX = TypeUtils.parseSignature("int getIndex(String, Class[])");
    private static final Signature SIGNATURE_GET_INDEX = new Signature("getIndex", Type.INT_TYPE, new Type[]{Constants.TYPE_SIGNATURE});
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    private static final Signature CONSTRUCTOR_GET_INDEX = TypeUtils.parseSignature("int getIndex(Class[])");
    private static final Signature INVOKE = TypeUtils.parseSignature("Object invoke(int, Object, Object[])");
    private static final Signature NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(int, Object[])");
    private static final Signature GET_MAX_INDEX = TypeUtils.parseSignature("int getMaxIndex()");
    private static final Signature GET_SIGNATURE_WITHOUT_RETURN_TYPE = TypeUtils.parseSignature("String getSignatureWithoutReturnType(String, Class[])");
    private static final Type FAST_CLASS = TypeUtils.parseType("net.sf.cglib.reflect.FastClass");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Type INVOCATION_TARGET_EXCEPTION = TypeUtils.parseType("java.lang.reflect.InvocationTargetException");
    private static final Type[] INVOCATION_TARGET_EXCEPTION_ARRAY = new Type[]{INVOCATION_TARGET_EXCEPTION};
    private static final int TOO_MANY_METHODS = 100;

    public FastClassEmitter(ClassVisitor classVisitor, String string, Class clazz) {
        super(classVisitor);
        this.begin_class(46, 1, string, FAST_CLASS, null, "<generated>");
        CodeEmitter codeEmitter = this.begin_method(1, CSTRUCT_CLASS, null, null);
        codeEmitter.load_this();
        codeEmitter.load_args();
        codeEmitter.super_invoke_constructor(CSTRUCT_CLASS);
        codeEmitter.return_value();
        codeEmitter.end_method();
        VisibilityPredicate visibilityPredicate = new VisibilityPredicate(clazz, false);
        List list = ReflectUtils.addAllMethods(clazz, new ArrayList());
        CollectionUtils.filter(list, visibilityPredicate);
        CollectionUtils.filter(list, new DuplicatesPredicate());
        ArrayList arrayList = new ArrayList(Arrays.asList(clazz.getDeclaredConstructors()));
        CollectionUtils.filter(arrayList, visibilityPredicate);
        this.emitIndexBySignature(list);
        this.emitIndexByClassArray(list);
        codeEmitter = this.begin_method(1, CONSTRUCTOR_GET_INDEX, null, null);
        codeEmitter.load_args();
        List list2 = CollectionUtils.transform(arrayList, MethodInfoTransformer.getInstance());
        EmitUtils.constructor_switch(codeEmitter, list2, new GetIndexCallback(codeEmitter, list2));
        codeEmitter.end_method();
        codeEmitter = this.begin_method(1, INVOKE, INVOCATION_TARGET_EXCEPTION_ARRAY, null);
        codeEmitter.load_arg(1);
        codeEmitter.checkcast(Type.getType((Class)clazz));
        codeEmitter.load_arg(0);
        FastClassEmitter.invokeSwitchHelper(codeEmitter, list, 2);
        codeEmitter.end_method();
        codeEmitter = this.begin_method(1, NEW_INSTANCE, INVOCATION_TARGET_EXCEPTION_ARRAY, null);
        codeEmitter.new_instance(Type.getType((Class)clazz));
        codeEmitter.dup();
        codeEmitter.load_arg(0);
        FastClassEmitter.invokeSwitchHelper(codeEmitter, arrayList, 1);
        codeEmitter.end_method();
        codeEmitter = this.begin_method(1, GET_MAX_INDEX, null, null);
        codeEmitter.push(list.size() - 1);
        codeEmitter.return_value();
        codeEmitter.end_method();
        this.end_class();
    }

    private void emitIndexBySignature(List list) {
        CodeEmitter codeEmitter = this.begin_method(1, SIGNATURE_GET_INDEX, null, null);
        List list2 = CollectionUtils.transform(list, new Transformer(){

            public Object transform(Object object) {
                return ReflectUtils.getSignature((Method)object).toString();
            }
        });
        codeEmitter.load_arg(0);
        codeEmitter.invoke_virtual(Constants.TYPE_OBJECT, TO_STRING);
        this.signatureSwitchHelper(codeEmitter, list2);
        codeEmitter.end_method();
    }

    private void emitIndexByClassArray(List list) {
        CodeEmitter codeEmitter = this.begin_method(1, METHOD_GET_INDEX, null, null);
        if (list.size() > 100) {
            List list2 = CollectionUtils.transform(list, new Transformer(){

                public Object transform(Object object) {
                    String string = ReflectUtils.getSignature((Method)object).toString();
                    return string.substring(0, string.lastIndexOf(41) + 1);
                }
            });
            codeEmitter.load_args();
            codeEmitter.invoke_static(FAST_CLASS, GET_SIGNATURE_WITHOUT_RETURN_TYPE);
            this.signatureSwitchHelper(codeEmitter, list2);
        } else {
            codeEmitter.load_args();
            List list3 = CollectionUtils.transform(list, MethodInfoTransformer.getInstance());
            EmitUtils.method_switch(codeEmitter, list3, new GetIndexCallback(codeEmitter, list3));
        }
        codeEmitter.end_method();
    }

    private void signatureSwitchHelper(final CodeEmitter codeEmitter, final List list) {
        ObjectSwitchCallback objectSwitchCallback = new ObjectSwitchCallback(){

            public void processCase(Object object, Label label) {
                codeEmitter.push(list.indexOf(object));
                codeEmitter.return_value();
            }

            public void processDefault() {
                codeEmitter.push(-1);
                codeEmitter.return_value();
            }
        };
        EmitUtils.string_switch(codeEmitter, list.toArray(new String[list.size()]), 1, objectSwitchCallback);
    }

    private static void invokeSwitchHelper(final CodeEmitter codeEmitter, List list, final int n) {
        final List list2 = CollectionUtils.transform(list, MethodInfoTransformer.getInstance());
        final Label label = codeEmitter.make_label();
        Block block = codeEmitter.begin_block();
        codeEmitter.process_switch(FastClassEmitter.getIntRange(list2.size()), new ProcessSwitchCallback(){

            public void processCase(int n2, Label label2) {
                MethodInfo methodInfo = (MethodInfo)list2.get(n2);
                Type[] typeArray = methodInfo.getSignature().getArgumentTypes();
                for (int i = 0; i < typeArray.length; ++i) {
                    codeEmitter.load_arg(n);
                    codeEmitter.aaload(i);
                    codeEmitter.unbox(typeArray[i]);
                }
                codeEmitter.invoke(methodInfo);
                if (!TypeUtils.isConstructor(methodInfo)) {
                    codeEmitter.box(methodInfo.getSignature().getReturnType());
                }
                codeEmitter.return_value();
            }

            public void processDefault() {
                codeEmitter.goTo(label);
            }
        });
        block.end();
        EmitUtils.wrap_throwable(block, INVOCATION_TARGET_EXCEPTION);
        codeEmitter.mark(label);
        codeEmitter.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Cannot find matching method/constructor");
    }

    private static int[] getIntRange(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private static class GetIndexCallback
    implements ObjectSwitchCallback {
        private CodeEmitter e;
        private Map indexes = new HashMap();

        public GetIndexCallback(CodeEmitter codeEmitter, List list) {
            this.e = codeEmitter;
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.indexes.put(iterator.next(), new Integer(n++));
            }
        }

        public void processCase(Object object, Label label) {
            this.e.push((Integer)this.indexes.get(object));
            this.e.return_value();
        }

        public void processDefault() {
            this.e.push(-1);
            this.e.return_value();
        }
    }
}

