/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.Local;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.ObjectSwitchCallback;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.proxy.CallbackGenerator;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

class MethodInterceptorGenerator
implements CallbackGenerator {
    public static final MethodInterceptorGenerator INSTANCE = new MethodInterceptorGenerator();
    static final String EMPTY_ARGS_NAME = "CGLIB$emptyArgs";
    static final String FIND_PROXY_NAME = "CGLIB$findMethodProxy";
    static final Class[] FIND_PROXY_TYPES = new Class[]{class$net$sf$cglib$core$Signature == null ? (class$net$sf$cglib$core$Signature = MethodInterceptorGenerator.class$("net.sf.cglib.core.Signature")) : class$net$sf$cglib$core$Signature};
    private static final Type ABSTRACT_METHOD_ERROR = TypeUtils.parseType("AbstractMethodError");
    private static final Type METHOD = TypeUtils.parseType("java.lang.reflect.Method");
    private static final Type METHOD_PROXY = TypeUtils.parseType("net.sf.cglib.proxy.MethodProxy");
    private static final Type METHOD_INTERCEPTOR = TypeUtils.parseType("net.sf.cglib.proxy.MethodInterceptor");
    private static final Signature GET_DECLARING_CLASS = TypeUtils.parseSignature("Class getDeclaringClass()");
    private static final Signature GET_CLASS_LOADER = TypeUtils.parseSignature("ClassLoader getClassLoader()");
    private static final Signature MAKE_PROXY = new Signature("create", METHOD_PROXY, new Type[]{Constants.TYPE_CLASS_LOADER, Constants.TYPE_CLASS, Constants.TYPE_CLASS, Constants.TYPE_STRING, Constants.TYPE_STRING, Constants.TYPE_STRING});
    private static final Signature INTERCEPT = new Signature("intercept", Constants.TYPE_OBJECT, new Type[]{Constants.TYPE_OBJECT, METHOD, Constants.TYPE_OBJECT_ARRAY, METHOD_PROXY});
    private static final Signature FIND_PROXY = new Signature("CGLIB$findMethodProxy", METHOD_PROXY, new Type[]{Constants.TYPE_SIGNATURE});
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    static /* synthetic */ Class class$net$sf$cglib$core$Signature;

    MethodInterceptorGenerator() {
    }

    private String getMethodField(Signature signature) {
        return signature.getName() + "$Method";
    }

    private String getMethodProxyField(Signature signature) {
        return signature.getName() + "$Proxy";
    }

    public void generate(ClassEmitter classEmitter, CallbackGenerator.Context context, List list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            Signature signature = context.getImplSignature(methodInfo);
            String string = this.getMethodField(signature);
            String string2 = this.getMethodProxyField(signature);
            hashMap.put(methodInfo.getSignature().toString(), string2);
            classEmitter.declare_field(26, string, METHOD, null, null);
            classEmitter.declare_field(26, string2, METHOD_PROXY, null, null);
            classEmitter.declare_field(26, EMPTY_ARGS_NAME, Constants.TYPE_OBJECT_ARRAY, null, null);
            CodeEmitter codeEmitter = classEmitter.begin_method(16, signature, methodInfo.getExceptionTypes(), null);
            if (TypeUtils.isAbstract(methodInfo.getModifiers())) {
                codeEmitter.throw_exception(ABSTRACT_METHOD_ERROR, methodInfo.toString() + " is abstract");
            } else {
                codeEmitter.load_this();
                codeEmitter.load_args();
                codeEmitter.super_invoke(methodInfo.getSignature());
            }
            codeEmitter.return_value();
            codeEmitter.end_method();
            codeEmitter = context.beginMethod(classEmitter, methodInfo);
            Label label = codeEmitter.make_label();
            context.emitCallback(codeEmitter, context.getIndex(methodInfo));
            codeEmitter.dup();
            codeEmitter.ifnull(label);
            codeEmitter.load_this();
            codeEmitter.getfield(string);
            if (methodInfo.getSignature().getArgumentTypes().length == 0) {
                codeEmitter.getfield(EMPTY_ARGS_NAME);
            } else {
                codeEmitter.create_arg_array();
            }
            codeEmitter.getfield(string2);
            codeEmitter.invoke_interface(METHOD_INTERCEPTOR, INTERCEPT);
            codeEmitter.unbox_or_zero(methodInfo.getSignature().getReturnType());
            codeEmitter.return_value();
            codeEmitter.mark(label);
            codeEmitter.load_this();
            codeEmitter.load_args();
            codeEmitter.super_invoke(methodInfo.getSignature());
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
        this.generateFindProxy(classEmitter, hashMap);
    }

    public void generateStatic(CodeEmitter codeEmitter, CallbackGenerator.Context context, List list) {
        Local local = codeEmitter.make_local();
        EmitUtils.load_class_this(codeEmitter);
        codeEmitter.dup();
        codeEmitter.store_local(local);
        codeEmitter.invoke_virtual(Constants.TYPE_CLASS, GET_CLASS_LOADER);
        codeEmitter.push(0);
        codeEmitter.newarray();
        codeEmitter.putfield(EMPTY_ARGS_NAME);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            codeEmitter.dup();
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            Signature signature = context.getImplSignature(methodInfo);
            EmitUtils.load_method(codeEmitter, methodInfo);
            codeEmitter.dup();
            codeEmitter.putfield(this.getMethodField(signature));
            Signature signature2 = methodInfo.getSignature();
            codeEmitter.invoke_virtual(METHOD, GET_DECLARING_CLASS);
            codeEmitter.load_local(local);
            codeEmitter.push(signature2.getDescriptor());
            codeEmitter.push(signature2.getName());
            codeEmitter.push(signature.getName());
            codeEmitter.invoke_static(METHOD_PROXY, MAKE_PROXY);
            codeEmitter.putfield(this.getMethodProxyField(signature));
        }
    }

    public void generateFindProxy(ClassEmitter classEmitter, final Map map) {
        final CodeEmitter codeEmitter = classEmitter.begin_method(9, FIND_PROXY, null, null);
        codeEmitter.load_arg(0);
        codeEmitter.invoke_virtual(Constants.TYPE_OBJECT, TO_STRING);
        ObjectSwitchCallback objectSwitchCallback = new ObjectSwitchCallback(){

            public void processCase(Object object, Label label) {
                codeEmitter.getfield((String)map.get(object));
                codeEmitter.return_value();
            }

            public void processDefault() {
                codeEmitter.aconst_null();
                codeEmitter.return_value();
            }
        };
        EmitUtils.string_switch(codeEmitter, map.keySet().toArray(new String[0]), 1, objectSwitchCallback);
        codeEmitter.end_method();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

