/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.proxy.CallbackGenerator;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

class LazyLoaderGenerator
implements CallbackGenerator {
    public static final LazyLoaderGenerator INSTANCE = new LazyLoaderGenerator();
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");
    private static final Type LAZY_LOADER = TypeUtils.parseType("net.sf.cglib.proxy.LazyLoader");

    LazyLoaderGenerator() {
    }

    public void generate(ClassEmitter classEmitter, CallbackGenerator.Context context, List list) {
        CodeEmitter codeEmitter;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            if (TypeUtils.isProtected(methodInfo.getModifiers())) continue;
            int n = context.getIndex(methodInfo);
            hashSet.add(new Integer(n));
            codeEmitter = context.beginMethod(classEmitter, methodInfo);
            codeEmitter.load_this();
            codeEmitter.dup();
            codeEmitter.invoke_virtual_this(this.loadMethod(n));
            codeEmitter.checkcast(methodInfo.getClassInfo().getType());
            codeEmitter.load_args();
            codeEmitter.invoke(methodInfo);
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            String string = "CGLIB$LAZY_LOADER_" + n;
            classEmitter.declare_field(2, string, Constants.TYPE_OBJECT, null, null);
            codeEmitter = classEmitter.begin_method(50, this.loadMethod(n), null, null);
            codeEmitter.load_this();
            codeEmitter.getfield(string);
            codeEmitter.dup();
            Label label = codeEmitter.make_label();
            codeEmitter.ifnonnull(label);
            codeEmitter.pop();
            codeEmitter.load_this();
            context.emitCallback(codeEmitter, n);
            codeEmitter.invoke_interface(LAZY_LOADER, LOAD_OBJECT);
            codeEmitter.dup_x1();
            codeEmitter.putfield(string);
            codeEmitter.mark(label);
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
    }

    private Signature loadMethod(int n) {
        return new Signature("CGLIB$LOAD_PRIVATE_" + n, Constants.TYPE_OBJECT, Constants.TYPES_EMPTY);
    }

    public void generateStatic(CodeEmitter codeEmitter, CallbackGenerator.Context context, List list) {
    }
}

