/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.util.Iterator;
import java.util.List;
import net.sf.cglib.core.Block;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.proxy.CallbackGenerator;
import org.objectweb.asm.Type;

class InvocationHandlerGenerator
implements CallbackGenerator {
    public static final InvocationHandlerGenerator INSTANCE = new InvocationHandlerGenerator();
    private static final Type INVOCATION_HANDLER = TypeUtils.parseType("net.sf.cglib.proxy.InvocationHandler");
    private static final Type UNDECLARED_THROWABLE_EXCEPTION = TypeUtils.parseType("net.sf.cglib.proxy.UndeclaredThrowableException");
    private static final Type METHOD = TypeUtils.parseType("java.lang.reflect.Method");
    private static final Signature INVOKE = TypeUtils.parseSignature("Object invoke(Object, java.lang.reflect.Method, Object[])");

    InvocationHandlerGenerator() {
    }

    public void generate(ClassEmitter classEmitter, CallbackGenerator.Context context, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            Signature signature = context.getImplSignature(methodInfo);
            classEmitter.declare_field(26, signature.getName(), METHOD, null, null);
            CodeEmitter codeEmitter = context.beginMethod(classEmitter, methodInfo);
            Block block = codeEmitter.begin_block();
            context.emitCallback(codeEmitter, context.getIndex(methodInfo));
            codeEmitter.load_this();
            codeEmitter.getfield(signature.getName());
            codeEmitter.create_arg_array();
            codeEmitter.invoke_interface(INVOCATION_HANDLER, INVOKE);
            codeEmitter.unbox(methodInfo.getSignature().getReturnType());
            codeEmitter.return_value();
            block.end();
            EmitUtils.wrap_undeclared_throwable(codeEmitter, block, methodInfo.getExceptionTypes(), UNDECLARED_THROWABLE_EXCEPTION);
            codeEmitter.end_method();
        }
    }

    public void generateStatic(CodeEmitter codeEmitter, CallbackGenerator.Context context, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            EmitUtils.load_method(codeEmitter, methodInfo);
            codeEmitter.putfield(context.getImplSignature(methodInfo).getName());
        }
    }
}

