/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.util.Iterator;
import java.util.List;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.proxy.CallbackGenerator;
import org.objectweb.asm.Type;

class FixedValueGenerator
implements CallbackGenerator {
    public static final FixedValueGenerator INSTANCE = new FixedValueGenerator();
    private static final Type FIXED_VALUE = TypeUtils.parseType("net.sf.cglib.proxy.FixedValue");
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");

    FixedValueGenerator() {
    }

    public void generate(ClassEmitter classEmitter, CallbackGenerator.Context context, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            CodeEmitter codeEmitter = context.beginMethod(classEmitter, methodInfo);
            context.emitCallback(codeEmitter, context.getIndex(methodInfo));
            codeEmitter.invoke_interface(FIXED_VALUE, LOAD_OBJECT);
            codeEmitter.unbox_or_zero(codeEmitter.getReturnType());
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
    }

    public void generateStatic(CodeEmitter codeEmitter, CallbackGenerator.Context context, List list) {
    }
}

