/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.Signature;
import org.objectweb.asm.Type;

public class TypeUtils {
    private static final Map transforms = new HashMap();
    private static final Map rtransforms = new HashMap();

    private TypeUtils() {
    }

    public static Type getType(String string) {
        return Type.getType((String)("L" + string.replace('.', '/') + ";"));
    }

    public static boolean isFinal(int n) {
        return (0x10 & n) != 0;
    }

    public static boolean isStatic(int n) {
        return (8 & n) != 0;
    }

    public static boolean isProtected(int n) {
        return (4 & n) != 0;
    }

    public static boolean isPublic(int n) {
        return (1 & n) != 0;
    }

    public static boolean isAbstract(int n) {
        return (0x400 & n) != 0;
    }

    public static boolean isInterface(int n) {
        return (0x200 & n) != 0;
    }

    public static boolean isPrivate(int n) {
        return (2 & n) != 0;
    }

    public static boolean isSynthetic(int n) {
        return (0x1000 & n) != 0;
    }

    public static String getPackageName(Type type) {
        return TypeUtils.getPackageName(TypeUtils.getClassName(type));
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        return n < 0 ? "" : string.substring(0, n);
    }

    public static String upperFirst(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String getClassName(Type type) {
        if (TypeUtils.isPrimitive(type)) {
            return (String)rtransforms.get(type.getDescriptor());
        }
        if (TypeUtils.isArray(type)) {
            return TypeUtils.getClassName(TypeUtils.getComponentType(type)) + "[]";
        }
        return type.getClassName();
    }

    public static Type[] add(Type[] typeArray, Type type) {
        if (typeArray == null) {
            return new Type[]{type};
        }
        List<Type> list = Arrays.asList(typeArray);
        if (list.contains(type)) {
            return typeArray;
        }
        Type[] typeArray2 = new Type[typeArray.length + 1];
        System.arraycopy(typeArray, 0, typeArray2, 0, typeArray.length);
        typeArray2[typeArray.length] = type;
        return typeArray2;
    }

    public static Type[] add(Type[] typeArray, Type[] typeArray2) {
        Type[] typeArray3 = new Type[typeArray.length + typeArray2.length];
        System.arraycopy(typeArray, 0, typeArray3, 0, typeArray.length);
        System.arraycopy(typeArray2, 0, typeArray3, typeArray.length, typeArray2.length);
        return typeArray3;
    }

    public static Type fromInternalName(String string) {
        return Type.getType((String)("L" + string + ";"));
    }

    public static Type[] fromInternalNames(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        Type[] typeArray = new Type[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            typeArray[i] = TypeUtils.fromInternalName(stringArray[i]);
        }
        return typeArray;
    }

    public static int getStackSize(Type[] typeArray) {
        int n = 0;
        for (int i = 0; i < typeArray.length; ++i) {
            n += typeArray[i].getSize();
        }
        return n;
    }

    public static String[] toInternalNames(Type[] typeArray) {
        if (typeArray == null) {
            return null;
        }
        String[] stringArray = new String[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            stringArray[i] = typeArray[i].getInternalName();
        }
        return stringArray;
    }

    public static Signature parseSignature(String string) {
        int n = string.indexOf(32);
        int n2 = string.indexOf(40, n);
        int n3 = string.indexOf(41, n2);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, n2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Iterator iterator = TypeUtils.parseTypes(string, n2 + 1, n3).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        stringBuffer.append(')');
        stringBuffer.append(TypeUtils.map(string2));
        return new Signature(string3, stringBuffer.toString());
    }

    public static Type parseType(String string) {
        return Type.getType((String)TypeUtils.map(string));
    }

    public static Type[] parseTypes(String string) {
        List list = TypeUtils.parseTypes(string, 0, string.length());
        Type[] typeArray = new Type[list.size()];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = Type.getType((String)((String)list.get(i)));
        }
        return typeArray;
    }

    public static Signature parseConstructor(Type[] typeArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < typeArray.length; ++i) {
            stringBuffer.append(typeArray[i].getDescriptor());
        }
        stringBuffer.append(")");
        stringBuffer.append("V");
        return new Signature("<init>", stringBuffer.toString());
    }

    public static Signature parseConstructor(String string) {
        return TypeUtils.parseSignature("void <init>(" + string + ")");
    }

    private static List parseTypes(String string, int n, int n2) {
        int n3;
        ArrayList<String> arrayList = new ArrayList<String>(5);
        while ((n3 = string.indexOf(44, n)) >= 0) {
            arrayList.add(TypeUtils.map(string.substring(n, n3).trim()));
            n = n3 + 1;
        }
        arrayList.add(TypeUtils.map(string.substring(n, n2).trim()));
        return arrayList;
    }

    private static String map(String string) {
        if (string.equals("")) {
            return string;
        }
        String string2 = (String)transforms.get(string);
        if (string2 != null) {
            return string2;
        }
        if (string.indexOf(46) < 0) {
            return TypeUtils.map("java.lang." + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((n = string.indexOf("[]", n) + 1) > 0) {
            stringBuffer.append('[');
        }
        string = string.substring(0, string.length() - stringBuffer.length() * 2);
        stringBuffer.append('L').append(string.replace('.', '/')).append(';');
        return stringBuffer.toString();
    }

    public static Type getBoxedType(Type type) {
        switch (type.getSort()) {
            case 2: {
                return Constants.TYPE_CHARACTER;
            }
            case 1: {
                return Constants.TYPE_BOOLEAN;
            }
            case 8: {
                return Constants.TYPE_DOUBLE;
            }
            case 6: {
                return Constants.TYPE_FLOAT;
            }
            case 7: {
                return Constants.TYPE_LONG;
            }
            case 5: {
                return Constants.TYPE_INTEGER;
            }
            case 4: {
                return Constants.TYPE_SHORT;
            }
            case 3: {
                return Constants.TYPE_BYTE;
            }
        }
        return type;
    }

    public static Type getUnboxedType(Type type) {
        if (Constants.TYPE_INTEGER.equals((Object)type)) {
            return Type.INT_TYPE;
        }
        if (Constants.TYPE_BOOLEAN.equals((Object)type)) {
            return Type.BOOLEAN_TYPE;
        }
        if (Constants.TYPE_DOUBLE.equals((Object)type)) {
            return Type.DOUBLE_TYPE;
        }
        if (Constants.TYPE_LONG.equals((Object)type)) {
            return Type.LONG_TYPE;
        }
        if (Constants.TYPE_CHARACTER.equals((Object)type)) {
            return Type.CHAR_TYPE;
        }
        if (Constants.TYPE_BYTE.equals((Object)type)) {
            return Type.BYTE_TYPE;
        }
        if (Constants.TYPE_FLOAT.equals((Object)type)) {
            return Type.FLOAT_TYPE;
        }
        if (Constants.TYPE_SHORT.equals((Object)type)) {
            return Type.SHORT_TYPE;
        }
        return type;
    }

    public static boolean isArray(Type type) {
        return type.getSort() == 9;
    }

    public static Type getComponentType(Type type) {
        if (!TypeUtils.isArray(type)) {
            throw new IllegalArgumentException("Type " + type + " is not an array");
        }
        return Type.getType((String)type.getDescriptor().substring(1));
    }

    public static boolean isPrimitive(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    public static String emulateClassGetName(Type type) {
        if (TypeUtils.isArray(type)) {
            return type.getDescriptor().replace('/', '.');
        }
        return TypeUtils.getClassName(type);
    }

    public static boolean isConstructor(MethodInfo methodInfo) {
        return methodInfo.getSignature().getName().equals("<init>");
    }

    public static Type[] getTypes(Class[] classArray) {
        if (classArray == null) {
            return null;
        }
        Type[] typeArray = new Type[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            typeArray[i] = Type.getType((Class)classArray[i]);
        }
        return typeArray;
    }

    public static int ICONST(int n) {
        switch (n) {
            case -1: {
                return 2;
            }
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 8;
            }
        }
        return -1;
    }

    public static int LCONST(long l) {
        if (l == 0L) {
            return 9;
        }
        if (l == 1L) {
            return 10;
        }
        return -1;
    }

    public static int FCONST(float f) {
        if (f == 0.0f) {
            return 11;
        }
        if (f == 1.0f) {
            return 12;
        }
        if (f == 2.0f) {
            return 13;
        }
        return -1;
    }

    public static int DCONST(double d) {
        if (d == 0.0) {
            return 14;
        }
        if (d == 1.0) {
            return 15;
        }
        return -1;
    }

    public static int NEWARRAY(Type type) {
        switch (type.getSort()) {
            case 3: {
                return 8;
            }
            case 2: {
                return 5;
            }
            case 8: {
                return 7;
            }
            case 6: {
                return 6;
            }
            case 5: {
                return 10;
            }
            case 7: {
                return 11;
            }
            case 4: {
                return 9;
            }
            case 1: {
                return 4;
            }
        }
        return -1;
    }

    public static String escapeType(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block9: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '$': {
                    stringBuffer.append("$24");
                    continue block9;
                }
                case '.': {
                    stringBuffer.append("$2E");
                    continue block9;
                }
                case '[': {
                    stringBuffer.append("$5B");
                    continue block9;
                }
                case ';': {
                    stringBuffer.append("$3B");
                    continue block9;
                }
                case '(': {
                    stringBuffer.append("$28");
                    continue block9;
                }
                case ')': {
                    stringBuffer.append("$29");
                    continue block9;
                }
                case '/': {
                    stringBuffer.append("$2F");
                    continue block9;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    static {
        transforms.put("void", "V");
        transforms.put("byte", "B");
        transforms.put("char", "C");
        transforms.put("double", "D");
        transforms.put("float", "F");
        transforms.put("int", "I");
        transforms.put("long", "J");
        transforms.put("short", "S");
        transforms.put("boolean", "Z");
        CollectionUtils.reverse(transforms, rtransforms);
    }
}

