/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.sf.cglib.core.CodeGenerationException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.TraceClassVisitor;

public class DebuggingClassWriter
extends ClassWriter {
    public static final String DEBUG_LOCATION_PROPERTY = "cglib.debugLocation";
    private static String debugLocation = System.getProperty("cglib.debugLocation");
    private static boolean traceEnabled;
    private String className;
    private String superName;

    public DebuggingClassWriter(boolean bl) {
        super(bl);
    }

    public DebuggingClassWriter(boolean bl, int n, int n2) {
        super(bl);
    }

    public void visit(int n, int n2, String string, String string2, String[] stringArray, String string3) {
        this.className = string.replace('/', '.');
        this.superName = string2.replace('/', '.');
        super.visit(n, n2, string, string2, stringArray, string3);
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperName() {
        return this.superName;
    }

    public byte[] toByteArray() {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                byte[] byArray;
                block10: {
                    byArray = DebuggingClassWriter.super.toByteArray();
                    if (debugLocation != null) {
                        String string = DebuggingClassWriter.this.className.replace('.', File.separatorChar);
                        try {
                            new File(debugLocation + File.separatorChar + string).getParentFile().mkdirs();
                            File file = new File(new File(debugLocation), string + ".class");
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                            try {
                                ((OutputStream)bufferedOutputStream).write(byArray);
                            }
                            finally {
                                ((OutputStream)bufferedOutputStream).close();
                            }
                            if (!traceEnabled) break block10;
                            file = new File(new File(debugLocation), string + ".asm");
                            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                            try {
                                ClassReader classReader = new ClassReader(byArray);
                                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(bufferedOutputStream));
                                TraceClassVisitor traceClassVisitor = new TraceClassVisitor(null, printWriter);
                                classReader.accept((ClassVisitor)traceClassVisitor, false);
                                printWriter.flush();
                            }
                            finally {
                                ((OutputStream)bufferedOutputStream).close();
                            }
                        }
                        catch (IOException iOException) {
                            throw new CodeGenerationException(iOException);
                        }
                    }
                }
                return byArray;
            }
        });
    }

    static {
        if (debugLocation != null) {
            System.err.println("CGLIB debugging enabled, writing to '" + debugLocation + "'");
            try {
                Class.forName("org.objectweb.asm.util.TraceClassVisitor");
                traceEnabled = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

