/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.Transformer;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static Map bucket(Collection collection, Transformer transformer) {
        HashMap hashMap = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object = transformer.transform(e);
            LinkedList linkedList = (LinkedList)hashMap.get(object);
            if (linkedList == null) {
                linkedList = new LinkedList();
                hashMap.put(object, linkedList);
            }
            linkedList.add(e);
        }
        return hashMap;
    }

    public static void reverse(Map map, Map map2) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            map2.put(map.get(k), k);
        }
    }

    public static Collection filter(Collection collection, Predicate predicate) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (predicate.evaluate(iterator.next())) continue;
            iterator.remove();
        }
        return collection;
    }

    public static List transform(Collection collection, Transformer transformer) {
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(transformer.transform(iterator.next()));
        }
        return arrayList;
    }

    public static Map getIndexMap(List list) {
        HashMap hashMap = new HashMap();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            hashMap.put(iterator.next(), new Integer(n++));
        }
        return hashMap;
    }
}

