/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.core.ClassInfo;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeAdapter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Type;

public class ClassEmitter
extends ClassAdapter {
    private ClassInfo classInfo;
    private Map fieldInfo;
    private static int hookCounter;
    private CodeVisitor rawStaticInit;
    private CodeEmitter staticInit;
    private CodeEmitter staticHook;
    private Signature staticHookSig;

    public ClassEmitter(ClassVisitor classVisitor) {
        super(null);
        this.setTarget(classVisitor);
    }

    public ClassEmitter() {
        super(null);
    }

    public void setTarget(ClassVisitor classVisitor) {
        this.cv = classVisitor;
        this.fieldInfo = new HashMap();
        this.staticHook = null;
        this.staticInit = null;
        this.staticHookSig = null;
    }

    private static synchronized int getNextHook() {
        return ++hookCounter;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public void begin_class(int n, final int n2, String string, final Type type, final Type[] typeArray, String string2) {
        final Type type2 = Type.getType((String)("L" + string.replace('.', '/') + ";"));
        this.classInfo = new ClassInfo(){

            public Type getType() {
                return type2;
            }

            public Type getSuperType() {
                return type != null ? type : Constants.TYPE_OBJECT;
            }

            public Type[] getInterfaces() {
                return typeArray;
            }

            public int getModifiers() {
                return n2;
            }
        };
        this.cv.visit(n, n2, this.classInfo.getType().getInternalName(), this.classInfo.getSuperType().getInternalName(), TypeUtils.toInternalNames(typeArray), string2);
        this.init();
    }

    public CodeEmitter getStaticHook() {
        if (TypeUtils.isInterface(this.getAccess())) {
            throw new IllegalStateException("static hook is invalid for this class");
        }
        if (this.staticHook == null) {
            this.staticHookSig = new Signature("CGLIB$STATICHOOK" + ClassEmitter.getNextHook(), "()V");
            this.staticHook = this.begin_method(8, this.staticHookSig, null, null);
            if (this.staticInit != null) {
                this.staticInit.invoke_static_this(this.staticHookSig);
            }
        }
        return this.staticHook;
    }

    protected void init() {
    }

    public int getAccess() {
        return this.classInfo.getModifiers();
    }

    public Type getClassType() {
        return this.classInfo.getType();
    }

    public Type getSuperType() {
        return this.classInfo.getSuperType();
    }

    public void end_class() {
        if (this.staticHook != null && this.staticInit == null) {
            this.begin_static();
        }
        if (this.staticInit != null) {
            this.staticHook.return_value();
            this.staticHook.end_method();
            this.rawStaticInit.visitInsn(177);
            this.rawStaticInit.visitMaxs(0, 0);
            this.staticHook = null;
            this.staticInit = null;
            this.staticHookSig = null;
        }
        this.cv.visitEnd();
    }

    public CodeEmitter begin_method(int n, Signature signature, Type[] typeArray, Attribute attribute) {
        if (this.classInfo == null) {
            throw new IllegalStateException("classInfo is null! " + (Object)((Object)this));
        }
        CodeVisitor codeVisitor = this.cv.visitMethod(n, signature.getName(), signature.getDescriptor(), TypeUtils.toInternalNames(typeArray), attribute);
        if (signature.equals(Constants.SIG_STATIC) && !TypeUtils.isInterface(this.getAccess())) {
            this.rawStaticInit = codeVisitor;
            CodeAdapter codeAdapter = new CodeAdapter(codeVisitor){

                public void visitMaxs(int n, int n2) {
                }

                public void visitInsn(int n) {
                    if (n != 177) {
                        super.visitInsn(n);
                    }
                }
            };
            this.staticInit = new CodeEmitter(this, (CodeVisitor)codeAdapter, n, signature, typeArray);
            if (this.staticHook == null) {
                this.getStaticHook();
            } else {
                this.staticInit.invoke_static_this(this.staticHookSig);
            }
            return this.staticInit;
        }
        if (signature.equals(this.staticHookSig)) {
            return new CodeEmitter(this, codeVisitor, n, signature, typeArray){

                public boolean isStaticHook() {
                    return true;
                }
            };
        }
        return new CodeEmitter(this, codeVisitor, n, signature, typeArray);
    }

    public CodeEmitter begin_static() {
        return this.begin_method(8, Constants.SIG_STATIC, null, null);
    }

    public void declare_field(int n, String string, Type type, Object object, Attribute attribute) {
        FieldInfo fieldInfo = (FieldInfo)this.fieldInfo.get(string);
        FieldInfo fieldInfo2 = new FieldInfo(n, string, type, object);
        if (fieldInfo != null) {
            if (!fieldInfo2.equals(fieldInfo)) {
                throw new IllegalArgumentException("Field \"" + string + "\" has been declared differently");
            }
        } else {
            this.fieldInfo.put(string, fieldInfo2);
            this.cv.visitField(n, string, type.getDescriptor(), object, attribute);
        }
    }

    public void define_attribute(Attribute attribute) {
        this.cv.visitAttribute(attribute);
    }

    boolean isFieldDeclared(String string) {
        return this.fieldInfo.get(string) != null;
    }

    FieldInfo getFieldInfo(String string) {
        FieldInfo fieldInfo = (FieldInfo)this.fieldInfo.get(string);
        if (fieldInfo == null) {
            throw new IllegalArgumentException("Field " + string + " is not declared in " + this.getClassType().getClassName());
        }
        return fieldInfo;
    }

    public void visit(int n, int n2, String string, String string2, String[] stringArray, String string3) {
        this.begin_class(n, n2, string.replace('/', '.'), TypeUtils.fromInternalName(string2), TypeUtils.fromInternalNames(stringArray), string3);
    }

    public void visitEnd() {
        this.end_class();
    }

    public void visitField(int n, String string, String string2, Object object, Attribute attribute) {
        this.declare_field(n, string, Type.getType((String)string2), object, attribute);
    }

    public CodeVisitor visitMethod(int n, String string, String string2, String[] stringArray, Attribute attribute) {
        return this.begin_method(n, new Signature(string, string2), TypeUtils.fromInternalNames(stringArray), attribute);
    }

    public void visitAttribute(Attribute attribute) {
        this.define_attribute(attribute);
    }

    static class FieldInfo {
        int access;
        String name;
        Type type;
        Object value;

        public FieldInfo(int n, String string, Type type, Object object) {
            this.access = n;
            this.name = string;
            this.type = type;
            this.value = object;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof FieldInfo)) {
                return false;
            }
            FieldInfo fieldInfo = (FieldInfo)object;
            if (this.access != fieldInfo.access || !this.name.equals(fieldInfo.name) || !this.type.equals((Object)fieldInfo.type)) {
                return false;
            }
            if (this.value == null ^ fieldInfo.value == null) {
                return false;
            }
            return this.value == null || this.value.equals(fieldInfo.value);
        }

        public int hashCode() {
            return this.access ^ this.name.hashCode() ^ this.type.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }
}

