/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sf.cglib.core.ClassGenerator;
import net.sf.cglib.core.ClassNameReader;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.DefaultGeneratorStrategy;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.GeneratorStrategy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.ReflectUtils;
import org.objectweb.asm.ClassReader;

public abstract class AbstractClassGenerator
implements ClassGenerator {
    private static final Object NAME_KEY = new Object();
    private static final ThreadLocal CURRENT = new ThreadLocal();
    private GeneratorStrategy strategy = DefaultGeneratorStrategy.INSTANCE;
    private NamingPolicy namingPolicy = DefaultNamingPolicy.INSTANCE;
    private Source source;
    private ClassLoader classLoader;
    private String namePrefix;
    private Object key;
    private boolean useCache = true;
    private String className;
    private boolean attemptLoad;

    protected AbstractClassGenerator(Source source) {
        this.source = source;
    }

    protected void setNamePrefix(String string) {
        this.namePrefix = string;
    }

    protected final String getClassName() {
        if (this.className == null) {
            this.className = this.getClassName(this.getClassLoader());
        }
        return this.className;
    }

    private String getClassName(ClassLoader classLoader) {
        final Set set = this.getClassNameCache(classLoader);
        return this.namingPolicy.getClassName(this.namePrefix, this.source.name, this.key, new Predicate(){

            public boolean evaluate(Object object) {
                return set.contains(object);
            }
        });
    }

    private Set getClassNameCache(ClassLoader classLoader) {
        return (Set)((Map)this.source.cache.get(classLoader)).get(NAME_KEY);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setNamingPolicy(NamingPolicy namingPolicy) {
        if (namingPolicy == null) {
            namingPolicy = DefaultNamingPolicy.INSTANCE;
        }
        this.namingPolicy = namingPolicy;
    }

    public NamingPolicy getNamingPolicy() {
        return this.namingPolicy;
    }

    public void setUseCache(boolean bl) {
        this.useCache = bl;
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public void setAttemptLoad(boolean bl) {
        this.attemptLoad = bl;
    }

    public boolean getAttemptLoad() {
        return this.attemptLoad;
    }

    public void setStrategy(GeneratorStrategy generatorStrategy) {
        if (generatorStrategy == null) {
            generatorStrategy = DefaultGeneratorStrategy.INSTANCE;
        }
        this.strategy = generatorStrategy;
    }

    public GeneratorStrategy getStrategy() {
        return this.strategy;
    }

    public static AbstractClassGenerator getCurrent() {
        return (AbstractClassGenerator)CURRENT.get();
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.classLoader;
        if (classLoader == null) {
            classLoader = this.getDefaultClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            throw new IllegalStateException("Cannot determine classloader");
        }
        return classLoader;
    }

    protected abstract ClassLoader getDefaultClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object create(Object object) {
        try {
            Class clazz = null;
            Source source = this.source;
            synchronized (source) {
                Reference reference;
                ClassLoader classLoader = this.getClassLoader();
                HashMap<Object, Object> hashMap = null;
                hashMap = (HashMap<Object, Object>)this.source.cache.get(classLoader);
                if (hashMap == null) {
                    hashMap = new HashMap<Object, Object>();
                    hashMap.put(NAME_KEY, new HashSet());
                    this.source.cache.put(classLoader, hashMap);
                } else if (this.useCache) {
                    reference = (Reference)hashMap.get(object);
                    clazz = reference == null ? null : reference.get();
                }
                if (clazz != null) {
                    return this.firstInstance(clazz);
                }
                reference = CURRENT.get();
                CURRENT.set(this);
                try {
                    Object object2;
                    this.key = object;
                    if (this.attemptLoad) {
                        try {
                            clazz = classLoader.loadClass(this.getClassName());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (clazz == null) {
                        object2 = this.strategy.generate(this);
                        String string = ClassNameReader.getClassName(new ClassReader(object2));
                        this.getClassNameCache(classLoader).add(string);
                        clazz = ReflectUtils.defineClass(string, object2, classLoader);
                    }
                    if (this.useCache) {
                        hashMap.put(object, new WeakReference(clazz));
                    }
                    object2 = this.firstInstance(clazz);
                    return object2;
                }
                finally {
                    CURRENT.set(reference);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Exception exception) {
            throw new CodeGenerationException(exception);
        }
    }

    protected abstract Object firstInstance(Class var1) throws Exception;

    protected abstract Object nextInstance(Object var1) throws Exception;

    protected static class Source {
        String name;
        Map cache = new WeakHashMap();

        public Source(String string) {
            this.name = string;
        }
    }
}

