/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.beans;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.beans.BulkBeanException;
import net.sf.cglib.core.Block;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.Local;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

class BulkBeanEmitter
extends ClassEmitter {
    private static final Signature GET_PROPERTY_VALUES = TypeUtils.parseSignature("void getPropertyValues(Object, Object[])");
    private static final Signature SET_PROPERTY_VALUES = TypeUtils.parseSignature("void setPropertyValues(Object, Object[])");
    private static final Signature CSTRUCT_EXCEPTION = TypeUtils.parseConstructor("Throwable, int");
    private static final Type BULK_BEAN = TypeUtils.parseType("net.sf.cglib.beans.BulkBean");
    private static final Type BULK_BEAN_EXCEPTION = TypeUtils.parseType("net.sf.cglib.beans.BulkBeanException");

    public BulkBeanEmitter(ClassVisitor classVisitor, String string, Class clazz, String[] stringArray, String[] stringArray2, Class[] classArray) {
        super(classVisitor);
        Method[] methodArray = new Method[stringArray.length];
        Method[] methodArray2 = new Method[stringArray2.length];
        BulkBeanEmitter.validate(clazz, stringArray, stringArray2, classArray, methodArray, methodArray2);
        this.begin_class(46, 1, string, BULK_BEAN, null, "<generated>");
        EmitUtils.null_constructor(this);
        this.generateGet(clazz, methodArray);
        this.generateSet(clazz, methodArray2);
        this.end_class();
    }

    private void generateGet(Class clazz, Method[] methodArray) {
        CodeEmitter codeEmitter = this.begin_method(1, GET_PROPERTY_VALUES, null, null);
        if (methodArray.length >= 0) {
            codeEmitter.load_arg(0);
            codeEmitter.checkcast(Type.getType((Class)clazz));
            Local local = codeEmitter.make_local();
            codeEmitter.store_local(local);
            for (int i = 0; i < methodArray.length; ++i) {
                if (methodArray[i] == null) continue;
                MethodInfo methodInfo = ReflectUtils.getMethodInfo(methodArray[i]);
                codeEmitter.load_arg(1);
                codeEmitter.push(i);
                codeEmitter.load_local(local);
                codeEmitter.invoke(methodInfo);
                codeEmitter.box(methodInfo.getSignature().getReturnType());
                codeEmitter.aastore();
            }
        }
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void generateSet(Class clazz, Method[] methodArray) {
        CodeEmitter codeEmitter = this.begin_method(1, SET_PROPERTY_VALUES, null, null);
        if (methodArray.length > 0) {
            Local local = codeEmitter.make_local(Type.INT_TYPE);
            codeEmitter.push(0);
            codeEmitter.store_local(local);
            codeEmitter.load_arg(0);
            codeEmitter.checkcast(Type.getType((Class)clazz));
            codeEmitter.load_arg(1);
            Block block = codeEmitter.begin_block();
            int n = 0;
            for (int i = 0; i < methodArray.length; ++i) {
                if (methodArray[i] == null) continue;
                MethodInfo methodInfo = ReflectUtils.getMethodInfo(methodArray[i]);
                int n2 = i - n;
                if (n2 > 0) {
                    codeEmitter.iinc(local, n2);
                    n = i;
                }
                codeEmitter.dup2();
                codeEmitter.aaload(i);
                codeEmitter.unbox(methodInfo.getSignature().getArgumentTypes()[0]);
                codeEmitter.invoke(methodInfo);
            }
            block.end();
            codeEmitter.return_value();
            codeEmitter.catch_exception(block, Constants.TYPE_THROWABLE);
            codeEmitter.new_instance(BULK_BEAN_EXCEPTION);
            codeEmitter.dup_x1();
            codeEmitter.swap();
            codeEmitter.load_local(local);
            codeEmitter.invoke_constructor(BULK_BEAN_EXCEPTION, CSTRUCT_EXCEPTION);
            codeEmitter.athrow();
        } else {
            codeEmitter.return_value();
        }
        codeEmitter.end_method();
    }

    private static void validate(Class clazz, String[] stringArray, String[] stringArray2, Class[] classArray, Method[] methodArray, Method[] methodArray2) {
        int n = -1;
        if (stringArray2.length != classArray.length || stringArray.length != classArray.length) {
            throw new BulkBeanException("accessor array length must be equal type array length", n);
        }
        try {
            for (n = 0; n < classArray.length; ++n) {
                Method method;
                if (stringArray[n] != null) {
                    method = ReflectUtils.findDeclaredMethod(clazz, stringArray[n], null);
                    if (method.getReturnType() != classArray[n]) {
                        throw new BulkBeanException("Specified type " + classArray[n] + " does not match declared type " + method.getReturnType(), n);
                    }
                    if (Modifier.isPrivate(method.getModifiers())) {
                        throw new BulkBeanException("Property is private", n);
                    }
                    methodArray[n] = method;
                }
                if (stringArray2[n] == null) continue;
                method = ReflectUtils.findDeclaredMethod(clazz, stringArray2[n], new Class[]{classArray[n]});
                if (Modifier.isPrivate(method.getModifiers())) {
                    throw new BulkBeanException("Property is private", n);
                }
                methodArray2[n] = method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new BulkBeanException("Cannot find specified property", n);
        }
    }
}

