/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.beans;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.ObjectSwitchCallback;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

class BeanMapEmitter
extends ClassEmitter {
    private static final Type BEAN_MAP = TypeUtils.parseType("net.sf.cglib.beans.BeanMap");
    private static final Type FIXED_KEY_SET = TypeUtils.parseType("net.sf.cglib.beans.FixedKeySet");
    private static final Signature CSTRUCT_OBJECT = TypeUtils.parseConstructor("Object");
    private static final Signature CSTRUCT_STRING_ARRAY = TypeUtils.parseConstructor("String[]");
    private static final Signature BEAN_MAP_GET = TypeUtils.parseSignature("Object get(Object, Object)");
    private static final Signature BEAN_MAP_PUT = TypeUtils.parseSignature("Object put(Object, Object, Object)");
    private static final Signature KEY_SET = TypeUtils.parseSignature("java.util.Set keySet()");
    private static final Signature NEW_INSTANCE = new Signature("newInstance", BEAN_MAP, new Type[]{Constants.TYPE_OBJECT});
    private static final Signature GET_PROPERTY_TYPE = TypeUtils.parseSignature("Class getPropertyType(String)");

    public BeanMapEmitter(ClassVisitor classVisitor, String string, Class clazz, int n) {
        super(classVisitor);
        String[] stringArray;
        this.begin_class(46, 1, string, BEAN_MAP, null, "<generated>");
        EmitUtils.null_constructor(this);
        EmitUtils.factory_method(this, NEW_INSTANCE);
        this.generateConstructor();
        Map map = this.makePropertyMap(ReflectUtils.getBeanGetters(clazz));
        Map map2 = this.makePropertyMap(ReflectUtils.getBeanSetters(clazz));
        HashMap hashMap = new HashMap();
        hashMap.putAll(map);
        hashMap.putAll(map2);
        if (n != 0) {
            stringArray = hashMap.keySet().iterator();
            while (stringArray.hasNext()) {
                String string2 = (String)stringArray.next();
                if (((n & 1) == 0 || map.containsKey(string2)) && ((n & 2) == 0 || map2.containsKey(string2))) continue;
                stringArray.remove();
                map.remove(string2);
                map2.remove(string2);
            }
        }
        this.generateGet(clazz, map);
        this.generatePut(clazz, map2);
        stringArray = this.getNames(hashMap);
        this.generateKeySet(stringArray);
        this.generateGetPropertyType(hashMap, stringArray);
        this.end_class();
    }

    private Map makePropertyMap(PropertyDescriptor[] propertyDescriptorArray) {
        HashMap<String, PropertyDescriptor> hashMap = new HashMap<String, PropertyDescriptor>();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            hashMap.put(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i]);
        }
        return hashMap;
    }

    private String[] getNames(Map map) {
        return map.keySet().toArray(new String[map.size()]);
    }

    private void generateConstructor() {
        CodeEmitter codeEmitter = this.begin_method(1, CSTRUCT_OBJECT, null, null);
        codeEmitter.load_this();
        codeEmitter.load_arg(0);
        codeEmitter.super_invoke_constructor(CSTRUCT_OBJECT);
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void generateGet(Class clazz, final Map map) {
        final CodeEmitter codeEmitter = this.begin_method(1, BEAN_MAP_GET, null, null);
        codeEmitter.load_arg(0);
        codeEmitter.checkcast(Type.getType((Class)clazz));
        codeEmitter.load_arg(1);
        codeEmitter.checkcast(Constants.TYPE_STRING);
        EmitUtils.string_switch(codeEmitter, this.getNames(map), 1, new ObjectSwitchCallback(){

            public void processCase(Object object, Label label) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)map.get(object);
                MethodInfo methodInfo = ReflectUtils.getMethodInfo(propertyDescriptor.getReadMethod());
                codeEmitter.invoke(methodInfo);
                codeEmitter.box(methodInfo.getSignature().getReturnType());
                codeEmitter.return_value();
            }

            public void processDefault() {
                codeEmitter.aconst_null();
                codeEmitter.return_value();
            }
        });
        codeEmitter.end_method();
    }

    private void generatePut(Class clazz, final Map map) {
        final CodeEmitter codeEmitter = this.begin_method(1, BEAN_MAP_PUT, null, null);
        codeEmitter.load_arg(0);
        codeEmitter.checkcast(Type.getType((Class)clazz));
        codeEmitter.load_arg(1);
        codeEmitter.checkcast(Constants.TYPE_STRING);
        EmitUtils.string_switch(codeEmitter, this.getNames(map), 1, new ObjectSwitchCallback(){

            public void processCase(Object object, Label label) {
                MethodInfo methodInfo;
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)map.get(object);
                if (propertyDescriptor.getReadMethod() == null) {
                    codeEmitter.aconst_null();
                } else {
                    methodInfo = ReflectUtils.getMethodInfo(propertyDescriptor.getReadMethod());
                    codeEmitter.dup();
                    codeEmitter.invoke(methodInfo);
                    codeEmitter.box(methodInfo.getSignature().getReturnType());
                }
                codeEmitter.swap();
                codeEmitter.load_arg(2);
                methodInfo = ReflectUtils.getMethodInfo(propertyDescriptor.getWriteMethod());
                codeEmitter.unbox(methodInfo.getSignature().getArgumentTypes()[0]);
                codeEmitter.invoke(methodInfo);
                codeEmitter.return_value();
            }

            public void processDefault() {
            }
        });
        codeEmitter.aconst_null();
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void generateKeySet(String[] stringArray) {
        this.declare_field(10, "keys", FIXED_KEY_SET, null, null);
        CodeEmitter codeEmitter = this.begin_static();
        codeEmitter.new_instance(FIXED_KEY_SET);
        codeEmitter.dup();
        EmitUtils.push_array(codeEmitter, stringArray);
        codeEmitter.invoke_constructor(FIXED_KEY_SET, CSTRUCT_STRING_ARRAY);
        codeEmitter.putfield("keys");
        codeEmitter.return_value();
        codeEmitter.end_method();
        codeEmitter = this.begin_method(1, KEY_SET, null, null);
        codeEmitter.load_this();
        codeEmitter.getfield("keys");
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void generateGetPropertyType(final Map map, String[] stringArray) {
        final CodeEmitter codeEmitter = this.begin_method(1, GET_PROPERTY_TYPE, null, null);
        codeEmitter.load_arg(0);
        EmitUtils.string_switch(codeEmitter, stringArray, 1, new ObjectSwitchCallback(){

            public void processCase(Object object, Label label) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)map.get(object);
                EmitUtils.load_class(codeEmitter, Type.getType(propertyDescriptor.getPropertyType()));
                codeEmitter.return_value();
            }

            public void processDefault() {
                codeEmitter.aconst_null();
                codeEmitter.return_value();
            }
        });
        codeEmitter.end_method();
    }
}

