/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.beans.BeanMapEmitter;
import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.KeyFactory;
import net.sf.cglib.core.ReflectUtils;
import org.objectweb.asm.ClassVisitor;

public abstract class BeanMap
implements Map {
    public static final int REQUIRE_GETTER = 1;
    public static final int REQUIRE_SETTER = 2;
    protected Object bean;
    static /* synthetic */ Class class$net$sf$cglib$beans$BeanMap;
    static /* synthetic */ Class class$net$sf$cglib$beans$BeanMap$Generator$BeanMapKey;

    public static BeanMap create(Object object) {
        Generator generator = new Generator();
        generator.setBean(object);
        return generator.create();
    }

    public abstract BeanMap newInstance(Object var1);

    public abstract Class getPropertyType(String var1);

    protected BeanMap() {
    }

    protected BeanMap(Object object) {
        this.setBean(object);
    }

    public Object get(Object object) {
        return this.get(this.bean, object);
    }

    public Object put(Object object, Object object2) {
        return this.put(this.bean, object, object2);
    }

    public abstract Object get(Object var1, Object var2);

    public abstract Object put(Object var1, Object var2, Object var3);

    public void setBean(Object object) {
        this.bean = object;
    }

    public Object getBean() {
        return this.bean;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object object) {
        return this.keySet().contains(object);
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = this.get(iterator.next());
            if ((object != null || object2 != null) && !object.equals(object2)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.keySet().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.put(k, map.get(k));
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size() != map.size()) {
            return false;
        }
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!map.containsKey(k)) {
                return false;
            }
            Object object2 = this.get(k);
            Object v = map.get(k);
            if (object2 != null ? object2.equals(v) : v == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object object = this.get(k);
            n += (k == null ? 0 : k.hashCode()) ^ (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    public Set entrySet() {
        HashMap hashMap = new HashMap();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            hashMap.put(k, this.get(k));
        }
        return Collections.unmodifiableMap(hashMap).entrySet();
    }

    public Collection values() {
        Set set = this.keySet();
        ArrayList<Object> arrayList = new ArrayList<Object>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.get(iterator.next()));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            stringBuffer.append(k);
            stringBuffer.append('=');
            stringBuffer.append(this.get(k));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source((class$net$sf$cglib$beans$BeanMap == null ? (class$net$sf$cglib$beans$BeanMap = BeanMap.class$("net.sf.cglib.beans.BeanMap")) : class$net$sf$cglib$beans$BeanMap).getName());
        private static final BeanMapKey KEY_FACTORY = (BeanMapKey)((Object)KeyFactory.create(class$net$sf$cglib$beans$BeanMap$Generator$BeanMapKey == null ? (class$net$sf$cglib$beans$BeanMap$Generator$BeanMapKey = BeanMap.class$("net.sf.cglib.beans.BeanMap$Generator$BeanMapKey")) : class$net$sf$cglib$beans$BeanMap$Generator$BeanMapKey, KeyFactory.CLASS_BY_NAME));
        private Object bean;
        private Class beanClass;
        private int require;

        public Generator() {
            super(SOURCE);
        }

        public void setBean(Object object) {
            this.bean = object;
            if (object != null) {
                this.beanClass = object.getClass();
            }
        }

        public void setBeanClass(Class clazz) {
            this.beanClass = clazz;
        }

        public void setRequire(int n) {
            this.require = n;
        }

        protected ClassLoader getDefaultClassLoader() {
            return this.beanClass.getClassLoader();
        }

        public BeanMap create() {
            if (this.beanClass == null) {
                throw new IllegalArgumentException("Class of bean unknown");
            }
            this.setNamePrefix(this.beanClass.getName());
            return (BeanMap)super.create(KEY_FACTORY.newInstance(this.beanClass, this.require));
        }

        public void generateClass(ClassVisitor classVisitor) throws Exception {
            new BeanMapEmitter(classVisitor, this.getClassName(), this.beanClass, this.require);
        }

        protected Object firstInstance(Class clazz) {
            return ((BeanMap)ReflectUtils.newInstance(clazz)).newInstance(this.bean);
        }

        protected Object nextInstance(Object object) {
            return ((BeanMap)object).newInstance(this.bean);
        }

        static interface BeanMapKey {
            public Object newInstance(Class var1, int var2);
        }
    }
}

