/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.web.tag;

import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.web.ServletCacheAdministrator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

public class FlushTag
extends TagSupport {
    ServletCacheAdministrator admin = null;
    String group = null;
    String key = null;
    String pattern = null;
    String scope = null;
    int cacheScope = -1;
    private String language = null;

    public void setGroup(String string) {
        this.group = string;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setScope(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("session")) {
                this.cacheScope = 3;
            } else if (string.equalsIgnoreCase("application")) {
                this.cacheScope = 4;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doStartTag() throws JspTagException {
        if (this.admin == null) {
            this.admin = ServletCacheAdministrator.getInstance(this.pageContext.getServletContext());
        }
        if (this.group != null) {
            if (this.cacheScope < 0) throw new JspTagException("A cache group was specified for flushing, but the scope wasn't supplied or was invalid");
            Cache cache = this.admin.getCache((HttpServletRequest)this.pageContext.getRequest(), this.cacheScope);
            cache.flushGroup(this.group);
            return 0;
        } else if (this.pattern != null) {
            if (this.cacheScope < 0) throw new JspTagException("A pattern was specified for flushing, but the scope wasn't supplied or was invalid");
            Cache cache = this.admin.getCache((HttpServletRequest)this.pageContext.getRequest(), this.cacheScope);
            cache.flushPattern(this.pattern);
            return 0;
        } else if (this.key == null) {
            if (this.cacheScope >= 0) {
                this.admin.setFlushTime(this.cacheScope);
                return 0;
            } else {
                this.admin.flushAll();
            }
            return 0;
        } else {
            if (this.cacheScope < 0) throw new JspTagException("A cache key was specified for flushing, but the scope wasn't supplied or was invalid");
            String string = this.admin.generateEntryKey(this.key, (HttpServletRequest)this.pageContext.getRequest(), this.cacheScope, this.language);
            Cache cache = this.admin.getCache((HttpServletRequest)this.pageContext.getRequest(), this.cacheScope);
            cache.flushEntry(string);
        }
        return 0;
    }
}

