/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.web.tag;

import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.util.StringUtil;
import com.opensymphony.oscache.web.ServletCacheAdministrator;
import com.opensymphony.oscache.web.WebEntryRefreshPolicy;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheTag
extends BodyTagSupport
implements TryCatchFinally {
    private static final int SECOND = 1;
    private static final int MINUTE = 60;
    private static final int HOUR = 3600;
    private static final int DAY = 86400;
    private static final int WEEK = 604800;
    private static final int MONTH = 2592000;
    private static final int YEAR = 31536000;
    private static final String CACHE_TAG_COUNTER_KEY = "__oscache_tag_counter";
    private static final int ONE_MINUTE = 60;
    private static final int ONE_HOUR = 3600;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static transient Log log = LogFactory.getLog((Class)(class$com$opensymphony$oscache$web$tag$CacheTag == null ? (class$com$opensymphony$oscache$web$tag$CacheTag = CacheTag.class$("com.opensymphony.oscache.web.tag.CacheTag")) : class$com$opensymphony$oscache$web$tag$CacheTag));
    private static final int SILENT_MODE = 1;
    boolean cancelUpdateRequired = false;
    private Cache cache = null;
    private List groups = null;
    private ServletCacheAdministrator admin = null;
    private String actualKey = null;
    private String content = null;
    private String cron = null;
    private String key = null;
    private String language = null;
    private String refreshPolicyClass = null;
    private String refreshPolicyParam = null;
    private boolean refresh = false;
    private boolean useBody = true;
    private int mode = 0;
    private int scope = 4;
    private int time = 3600;
    static /* synthetic */ Class class$com$opensymphony$oscache$web$tag$CacheTag;

    public void setDuration(String string) {
        try {
            this.time = this.parseDuration(string);
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed parsing simple duration format '" + string + "' (" + exception.getMessage() + "). Trying ISO-8601 format..."));
            }
            try {
                this.time = this.parseISO_8601_Duration(string);
            }
            catch (Exception exception2) {
                log.warn((Object)("The requested cache duration '" + string + "' is invalid (" + exception2.getMessage() + "). Reverting to the default timeout"));
                this.time = 3600;
            }
        }
    }

    public void setCron(String string) {
        this.cron = string;
    }

    public void setGroups(String string) {
        this.groups = StringUtil.split(string, ',');
    }

    void addGroup(String string) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        this.groups.add(string);
    }

    public void setKey(String string) {
        this.key = string;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setRefresh(boolean bl) {
        this.refresh = bl;
    }

    public void setMode(String string) {
        this.mode = "silent".equalsIgnoreCase(string) ? 1 : 0;
    }

    public void setRefreshpolicyclass(String string) {
        this.refreshPolicyClass = string;
    }

    public void setRefreshpolicyparam(String string) {
        this.refreshPolicyParam = string;
    }

    public void setScope(String string) {
        this.scope = string.equalsIgnoreCase("session") ? 3 : 4;
    }

    public void setTime(int n) {
        this.time = n;
    }

    public void setUseBody(boolean bl) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("<cache>: Set useBody to " + bl));
        }
        this.useBody = bl;
    }

    public int doAfterBody() throws JspTagException {
        String string = null;
        try {
            if (this.bodyContent != null && (this.useBody || this.time == 0) && (string = this.bodyContent.getString()) != null) {
                if (this.time != 0 || this.refreshPolicyClass != null) {
                    WebEntryRefreshPolicy webEntryRefreshPolicy;
                    block16: {
                        webEntryRefreshPolicy = null;
                        if (this.refreshPolicyClass != null) {
                            try {
                                webEntryRefreshPolicy = (WebEntryRefreshPolicy)Class.forName(this.refreshPolicyClass).newInstance();
                                webEntryRefreshPolicy.init(this.actualKey, this.refreshPolicyParam);
                            }
                            catch (Exception exception) {
                                if (!log.isInfoEnabled()) break block16;
                                log.info((Object)("<cache>: Problem instantiating or initializing refresh policy : " + this.refreshPolicyClass));
                            }
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("<cache>: Updating cache entry with new content : " + this.actualKey));
                    }
                    this.cancelUpdateRequired = false;
                    if (this.groups == null || this.groups.isEmpty()) {
                        this.cache.putInCache(this.actualKey, (Object)string, webEntryRefreshPolicy);
                    } else {
                        String[] stringArray = new String[this.groups.size()];
                        this.groups.toArray(stringArray);
                        this.cache.putInCache(this.actualKey, string, stringArray, webEntryRefreshPolicy, null);
                    }
                }
            } else if (!this.useBody && this.content != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("<cache>: Using cached version as instructed, useBody = false : " + this.actualKey));
                }
                string = this.content;
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("<cache>: Missing cached content : " + this.actualKey));
                }
                string = "Missing cached content";
            }
            if (this.mode != 1) {
                this.bodyContent.clearBody();
                this.bodyContent.write(string);
                this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
            }
        }
        catch (IOException iOException) {
            throw new JspTagException("IO Error: " + iOException.getMessage());
        }
        return 0;
    }

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public int doEndTag() throws JspTagException {
        return 6;
    }

    public void doFinally() {
        if (this.cancelUpdateRequired && this.actualKey != null) {
            this.cache.cancelUpdate(this.actualKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doStartTag() throws JspTagException {
        this.cancelUpdateRequired = false;
        this.useBody = true;
        this.content = null;
        int n = 2;
        if (this.admin == null) {
            this.admin = ServletCacheAdministrator.getInstance(this.pageContext.getServletContext());
        }
        this.cache = this.admin.getCache((HttpServletRequest)this.pageContext.getRequest(), this.scope);
        String string = null;
        if (this.key == null) {
            ServletRequest servletRequest = this.pageContext.getRequest();
            synchronized (servletRequest) {
                Object object = this.pageContext.getRequest().getAttribute(CACHE_TAG_COUNTER_KEY);
                string = object == null ? "1" : Integer.toString(Integer.parseInt((String)object) + 1);
            }
            this.pageContext.getRequest().setAttribute(CACHE_TAG_COUNTER_KEY, (Object)string);
        }
        this.actualKey = this.admin.generateEntryKey(this.key, (HttpServletRequest)this.pageContext.getRequest(), this.scope, this.language, string);
        try {
            this.content = this.refresh ? (String)this.cache.getFromCache(this.actualKey, 0, this.cron) : (String)this.cache.getFromCache(this.actualKey, this.time, this.cron);
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("<cache>: Using cached entry : " + this.actualKey));
                }
                if (this.content != null) {
                    if (this.mode != 1) {
                        this.pageContext.getOut().write(this.content);
                    }
                    n = 0;
                }
            }
            catch (IOException iOException) {
                throw new JspTagException("IO Exception: " + iOException.getMessage());
            }
        }
        catch (NeedsRefreshException needsRefreshException) {
            this.cancelUpdateRequired = true;
            this.content = (String)needsRefreshException.getCacheContent();
        }
        if (n == 2 && log.isDebugEnabled()) {
            log.debug((Object)("<cache>: Cached content not used: New cache entry, cache stale or scope flushed : " + this.actualKey));
        }
        return n;
    }

    private int parseDuration(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isDigit(string.charAt(i))) continue;
                n = Integer.parseInt(string.substring(0, i));
                switch (string.charAt(i)) {
                    case 's': {
                        n *= 1;
                        break;
                    }
                    case 'm': {
                        n *= 60;
                        break;
                    }
                    case 'h': {
                        n *= 3600;
                        break;
                    }
                    case 'd': {
                        n *= 86400;
                        break;
                    }
                    case 'w': {
                        n *= 604800;
                        break;
                    }
                }
                break;
            }
        }
        return n;
    }

    private int parseISO_8601_Duration(String string) throws Exception {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = string.indexOf("-");
        if (n10 > 0) {
            throw new Exception("Invalid duration (- must be at the beginning)");
        }
        String string2 = string.substring(n10 + 1);
        if (string2.charAt(0) != 'P') {
            throw new Exception("Invalid duration (P must be at the beginning)");
        }
        if ((string2 = string2.substring(1)).length() == 0) {
            throw new Exception("Invalid duration (nothing specified)");
        }
        n10 = string2.indexOf(84);
        String string3 = "";
        if (n10 > 0) {
            string3 = string2.substring(n10 + 1);
            if (string3.equals("")) {
                throw new Exception("Invalid duration (T with no time)");
            }
            string2 = string2.substring(0, n10);
        } else if (n10 == 0) {
            string3 = string2.substring(1);
            string2 = "";
        }
        if (!string2.equals("")) {
            this.validateDateFormat(string2);
            n3 = string2.indexOf(89);
            n2 = string2.indexOf(77);
            n = string2.indexOf(68);
            if (n3 != -1 && n2 != -1 && n3 > n2) {
                throw new Exception("Invalid duration (Date part not properly specified)");
            }
            if (n3 != -1 && n != -1 && n3 > n) {
                throw new Exception("Invalid duration (Date part not properly specified)");
            }
            if (n != -1 && n2 != -1 && n2 > n) {
                throw new Exception("Invalid duration (Date part not properly specified)");
            }
            if (n3 >= 0) {
                n4 = new Integer(string2.substring(0, n3));
            }
            if (n2 >= 0) {
                n5 = new Integer(string2.substring(n3 + 1, n2));
            }
            if (n >= 0) {
                n6 = n2 >= 0 ? new Integer(string2.substring(n2 + 1, n)) : (n3 >= 0 ? new Integer(string2.substring(n3 + 1, n)).intValue() : new Integer(string2.substring(0, n)).intValue());
            }
        }
        if (!string3.equals("")) {
            this.validateHourFormat(string3);
            n3 = string3.indexOf(72);
            n2 = string3.indexOf(77);
            n = string3.indexOf(83);
            if (n3 != -1 && n2 != -1 && n3 > n2) {
                throw new Exception("Invalid duration (Time part not properly specified)");
            }
            if (n3 != -1 && n != -1 && n3 > n) {
                throw new Exception("Invalid duration (Time part not properly specified)");
            }
            if (n != -1 && n2 != -1 && n2 > n) {
                throw new Exception("Invalid duration (Time part not properly specified)");
            }
            if (n3 >= 0) {
                n7 = new Integer(string3.substring(0, n3));
            }
            if (n2 >= 0) {
                n8 = new Integer(string3.substring(n3 + 1, n2));
            }
            if (n >= 0) {
                if (string3.length() != n + 1) {
                    throw new Exception("Invalid duration (Time part not properly specified)");
                }
                string3 = n2 >= 0 ? string3.substring(n2 + 1, string3.length() - 1) : (n3 >= 0 ? string3.substring(n3 + 1, string3.length() - 1) : string3.substring(0, string3.length() - 1));
                if (string3.indexOf(46) == string3.length() - 1) {
                    throw new Exception("Invalid duration (Time part not properly specified)");
                }
                n9 = new Double(string3).intValue();
            }
        }
        return n9 + n8 * 60 + n7 * 3600 + n6 * 86400 + n5 * 2592000 + n4 * 31536000;
    }

    private void validateDateFormat(String string) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isDigit(string.charAt(i)) && string.charAt(i) != 'Y' && string.charAt(i) != 'M' && string.charAt(i) != 'D') {
                throw new Exception("Invalid duration (Date part not properly specified)");
            }
            if (string.charAt(i) == 'Y') {
                ++n;
            }
            if (string.charAt(i) == 'M') {
                ++n2;
            }
            if (string.charAt(i) != 'D') continue;
            ++n3;
        }
        if (n > 1 || n2 > 1 || n3 > 1) {
            throw new Exception("Invalid duration (Date part not properly specified)");
        }
    }

    private void validateHourFormat(String string) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isDigit(string.charAt(i)) && string.charAt(i) != 'H' && string.charAt(i) != 'M' && string.charAt(i) != 'S' && string.charAt(i) != '.') {
                throw new Exception("Invalid duration (Time part not properly specified)");
            }
            if (string.charAt(i) == 'H') {
                ++n3;
            }
            if (string.charAt(i) == 'M') {
                ++n;
            }
            if (string.charAt(i) != 'S') continue;
            ++n2;
        }
        if (n3 > 1 || n > 1 || n2 > 1) {
            throw new Exception("Invalid duration (Time part not properly specified)");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

