/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.web.filter;

import com.opensymphony.oscache.web.filter.ResponseContent;
import com.opensymphony.oscache.web.filter.SplitServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private PrintWriter cachedWriter;
    private ResponseContent result = new ResponseContent();
    private SplitServletOutputStream cacheOut = null;
    private int status = 200;

    public CacheHttpServletResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public ResponseContent getContent() {
        this.result.commit();
        return this.result;
    }

    public void setContentType(String string) {
        super.setContentType(string);
        this.result.setContentType(string);
    }

    public void setDateHeader(String string, long l) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("dateheader: " + string + ": " + l));
        }
        if ("last-modified".equalsIgnoreCase(string)) {
            this.result.setLastModified(l);
        }
        super.setDateHeader(string, l);
    }

    public void setHeader(String string, String string2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("header: " + string + ": " + string2));
        }
        super.setHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("intheader: " + string + ": " + n));
        }
        super.setIntHeader(string, n);
    }

    public void setStatus(int n) {
        super.setStatus(n);
        this.status = n;
    }

    public void sendError(int n, String string) throws IOException {
        super.sendError(n, string);
        this.status = n;
    }

    public void sendError(int n) throws IOException {
        super.sendError(n);
        this.status = n;
    }

    public void setStatus(int n, String string) {
        super.setStatus(n, string);
        this.status = n;
    }

    public void sendRedirect(String string) throws IOException {
        this.status = 302;
        super.sendRedirect(string);
    }

    public int getStatus() {
        return this.status;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.result.setLocale(locale);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.cacheOut == null) {
            this.cacheOut = new SplitServletOutputStream(this.result.getOutputStream(), (OutputStream)super.getOutputStream());
        }
        return this.cacheOut;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.cachedWriter == null) {
            this.cachedWriter = new PrintWriter((OutputStream)this.getOutputStream());
        }
        return this.cachedWriter;
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
        if (this.cacheOut != null) {
            this.cacheOut.flush();
        }
        if (this.cachedWriter != null) {
            this.cachedWriter.flush();
        }
    }
}

