/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.web.filter;

import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.web.ServletCacheAdministrator;
import com.opensymphony.oscache.web.filter.CacheHttpServletResponseWrapper;
import com.opensymphony.oscache.web.filter.ResponseContent;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheFilter
implements Filter {
    private final Log log = LogFactory.getLog(this.getClass());
    private FilterConfig config;
    private ServletCacheAdministrator admin = null;
    private int cacheScope = 4;
    private int time = 3600;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("<cache>: filter in scope " + this.cacheScope));
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String string = this.admin.generateEntryKey(null, httpServletRequest, this.cacheScope);
        Cache cache = this.admin.getCache(httpServletRequest, this.cacheScope);
        try {
            long l;
            ResponseContent responseContent = (ResponseContent)cache.getFromCache(string, this.time);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("<cache>: Using cached entry for " + string));
            }
            if ((l = httpServletRequest.getDateHeader("If-Modified-Since")) >= responseContent.getLastModified()) {
                ((HttpServletResponse)servletResponse).setStatus(304);
                return;
            }
            responseContent.writeTo(servletResponse);
        }
        catch (NeedsRefreshException needsRefreshException) {
            boolean bl = false;
            try {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("<cache>: New cache entry, cache stale or cache scope flushed for " + string));
                }
                CacheHttpServletResponseWrapper cacheHttpServletResponseWrapper = new CacheHttpServletResponseWrapper((HttpServletResponse)servletResponse);
                filterChain.doFilter(servletRequest, (ServletResponse)cacheHttpServletResponseWrapper);
                cacheHttpServletResponseWrapper.flushBuffer();
                if (cacheHttpServletResponseWrapper.getStatus() == 200) {
                    cache.putInCache(string, cacheHttpServletResponseWrapper.getContent());
                    bl = true;
                }
            }
            finally {
                if (!bl) {
                    cache.cancelUpdate(string);
                }
            }
        }
    }

    public void init(FilterConfig filterConfig) {
        this.config = filterConfig;
        this.admin = ServletCacheAdministrator.getInstance(this.config.getServletContext());
        try {
            this.time = Integer.parseInt(this.config.getInitParameter("time"));
        }
        catch (Exception exception) {
            this.log.info((Object)"Could not get init paramter 'time', defaulting to one hour.");
        }
        try {
            String string = this.config.getInitParameter("scope");
            if (string.equals("session")) {
                this.cacheScope = 3;
            } else if (string.equals("application")) {
                this.cacheScope = 4;
            } else if (string.equals("request")) {
                this.cacheScope = 2;
            } else if (string.equals("page")) {
                this.cacheScope = 1;
            }
        }
        catch (Exception exception) {
            this.log.info((Object)"Could not get init paramter 'scope', defaulting to 'application'");
        }
    }
}

