/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.web;

import com.opensymphony.oscache.base.AbstractCacheAdministrator;
import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.CacheEntry;
import com.opensymphony.oscache.base.EntryRefreshPolicy;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.base.events.CacheEventListener;
import com.opensymphony.oscache.base.events.ScopeEvent;
import com.opensymphony.oscache.base.events.ScopeEventListener;
import com.opensymphony.oscache.base.events.ScopeEventType;
import com.opensymphony.oscache.web.ServletCache;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletCacheAdministrator
extends AbstractCacheAdministrator
implements Serializable {
    private static final transient Log log = LogFactory.getLog((Class)(class$com$opensymphony$oscache$web$ServletCacheAdministrator == null ? (class$com$opensymphony$oscache$web$ServletCacheAdministrator = ServletCacheAdministrator.class$("com.opensymphony.oscache.web.ServletCacheAdministrator")) : class$com$opensymphony$oscache$web$ServletCacheAdministrator));
    private static final String CACHE_USE_HOST_DOMAIN_KEY = "cache.use.host.domain.in.key";
    private static final String CACHE_KEY_KEY = "cache.key";
    private static final String DEFAULT_CACHE_KEY = "__oscache_cache";
    public static final String SESSION_SCOPE_NAME = "session";
    public static final String APPLICATION_SCOPE_NAME = "application";
    private static final String CACHE_ADMINISTRATOR_KEY = "__oscache_admin";
    public static final String HASH_KEY_SCOPE = "scope";
    public static final String HASH_KEY_SESSION_ID = "sessionId";
    public static final String HASH_KEY_CONTEXT_TMPDIR = "context.tempdir";
    private static final String FILE_SEPARATOR = "/";
    private static final char FILE_SEPARATOR_CHAR = "/".charAt(0);
    private static final short AVERAGE_KEY_LENGTH = 30;
    private static final String m_strBase64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private Map flushTimes;
    private String cacheKey;
    private boolean useHostDomainInKey = false;
    static /* synthetic */ Class class$com$opensymphony$oscache$web$ServletCacheAdministrator;
    static /* synthetic */ Class class$com$opensymphony$oscache$base$events$ScopeEventListener;

    private ServletCacheAdministrator(ServletContext servletContext, Properties properties) {
        super(properties);
        this.config.set(HASH_KEY_CONTEXT_TMPDIR, servletContext.getAttribute("javax.servlet.context.tempdir"));
        this.flushTimes = new HashMap();
        this.initHostDomainInKey();
        if (log.isInfoEnabled()) {
            log.info((Object)"Constructed ServletCacheAdministrator()");
        }
    }

    public static ServletCacheAdministrator getInstance(ServletContext servletContext) {
        return ServletCacheAdministrator.getInstance(servletContext, null);
    }

    public static ServletCacheAdministrator getInstance(ServletContext servletContext, Properties properties) {
        ServletCacheAdministrator servletCacheAdministrator = null;
        servletCacheAdministrator = (ServletCacheAdministrator)servletContext.getAttribute(CACHE_ADMINISTRATOR_KEY);
        if (servletCacheAdministrator == null) {
            servletCacheAdministrator = new ServletCacheAdministrator(servletContext, properties);
            servletContext.setAttribute(CACHE_ADMINISTRATOR_KEY, (Object)servletCacheAdministrator);
            if (log.isInfoEnabled()) {
                log.info((Object)"Created new instance of ServletCacheAdministrator");
            }
            servletCacheAdministrator.getAppScopeCache(servletContext);
        }
        return servletCacheAdministrator;
    }

    public static void destroyInstance(ServletContext servletContext) {
        ServletCacheAdministrator servletCacheAdministrator = null;
        servletCacheAdministrator = (ServletCacheAdministrator)servletContext.getAttribute(CACHE_ADMINISTRATOR_KEY);
        if (servletCacheAdministrator != null) {
            Cache cache = (Cache)servletContext.getAttribute(servletCacheAdministrator.getCacheKey());
            if (cache != null) {
                servletCacheAdministrator.finalizeListeners(cache);
                servletContext.removeAttribute(servletCacheAdministrator.getCacheKey());
                servletContext.removeAttribute(CACHE_ADMINISTRATOR_KEY);
                cache = null;
                if (log.isInfoEnabled()) {
                    log.info((Object)"Shut down the ServletCacheAdministrator");
                }
            }
            servletCacheAdministrator = null;
        }
    }

    public Cache getCache(HttpServletRequest httpServletRequest, int n) {
        if (n == 4) {
            return this.getAppScopeCache(httpServletRequest.getSession(true).getServletContext());
        }
        if (n == 3) {
            return this.getSessionScopeCache(httpServletRequest.getSession(true));
        }
        throw new RuntimeException("The supplied scope value of " + n + " is invalid. Acceptable values are PageContext.APPLICATION_SCOPE and PageContext.SESSION_SCOPE");
    }

    public Cache getAppScopeCache(ServletContext servletContext) {
        Cache cache = null;
        Object object = servletContext.getAttribute(this.getCacheKey());
        if (object == null || !(object instanceof Cache)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Created new application-scoped cache at key: " + this.getCacheKey()));
            }
            cache = this.createCache(4, null);
            servletContext.setAttribute(this.getCacheKey(), (Object)cache);
        } else {
            cache = (Cache)object;
        }
        return cache;
    }

    public Cache getSessionScopeCache(HttpSession httpSession) {
        Cache cache = null;
        Object object = httpSession.getAttribute(this.getCacheKey());
        if (object == null || !(object instanceof Cache)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Created new session-scoped cache in session " + httpSession.getId() + " at key: " + this.getCacheKey()));
            }
            cache = this.createCache(3, httpSession.getId());
            httpSession.setAttribute(this.getCacheKey(), (Object)cache);
        } else {
            cache = (Cache)object;
        }
        return cache;
    }

    public String getCacheKey() {
        if (this.cacheKey == null) {
            this.cacheKey = this.getProperty(CACHE_KEY_KEY);
            if (this.cacheKey == null) {
                this.cacheKey = DEFAULT_CACHE_KEY;
            }
        }
        return this.cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushTime(Date date, int n) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Flushing scope " + n + " at " + date));
        }
        Map map = this.flushTimes;
        synchronized (map) {
            if (date == null) {
                this.logError("setFlushTime called with a null date.");
                throw new IllegalArgumentException("setFlushTime called with a null date.");
            }
            this.dispatchScopeEvent(ScopeEventType.SCOPE_FLUSHED, n, date, null);
            this.flushTimes.put(new Integer(n), date);
        }
    }

    public void setFlushTime(int n) {
        this.setFlushTime(new Date(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getFlushTime(int n) {
        Map map = this.flushTimes;
        synchronized (map) {
            return (Date)this.flushTimes.get(new Integer(n));
        }
    }

    public Object getFromCache(int n, HttpServletRequest httpServletRequest, String string, int n2) throws NeedsRefreshException {
        Cache cache = this.getCache(httpServletRequest, n);
        string = this.generateEntryKey(string, httpServletRequest, n);
        return cache.getFromCache(string, n2);
    }

    public boolean isScopeFlushed(CacheEntry cacheEntry, int n) {
        Date date = this.getFlushTime(n);
        if (date != null) {
            long l = cacheEntry.getLastUpdate();
            return date.getTime() >= l;
        }
        return false;
    }

    public void addScopeEventListener(ScopeEventListener scopeEventListener) {
        this.listenerList.add(class$com$opensymphony$oscache$base$events$ScopeEventListener == null ? (class$com$opensymphony$oscache$base$events$ScopeEventListener = ServletCacheAdministrator.class$("com.opensymphony.oscache.base.events.ScopeEventListener")) : class$com$opensymphony$oscache$base$events$ScopeEventListener, scopeEventListener);
    }

    public void cancelUpdate(int n, HttpServletRequest httpServletRequest, String string) {
        Cache cache = this.getCache(httpServletRequest, n);
        string = this.generateEntryKey(string, httpServletRequest, n);
        cache.cancelUpdate(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll(Date date) {
        Map map = this.flushTimes;
        synchronized (map) {
            this.setFlushTime(date, 4);
            this.setFlushTime(date, 3);
            this.setFlushTime(date, 2);
            this.setFlushTime(date, 1);
        }
        this.dispatchScopeEvent(ScopeEventType.ALL_SCOPES_FLUSHED, -1, date, null);
    }

    public void flushAll() {
        this.flushAll(new Date());
    }

    public String generateEntryKey(String string, HttpServletRequest httpServletRequest, int n) {
        return this.generateEntryKey(string, httpServletRequest, n, null, null);
    }

    public String generateEntryKey(String string, HttpServletRequest httpServletRequest, int n, String string2) {
        return this.generateEntryKey(string, httpServletRequest, n, string2, null);
    }

    public String generateEntryKey(String string, HttpServletRequest httpServletRequest, int n, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(30);
        if (string2 != null) {
            stringBuffer.append(FILE_SEPARATOR).append(string2);
        }
        if (this.useHostDomainInKey) {
            stringBuffer.append(FILE_SEPARATOR).append(httpServletRequest.getServerName());
        }
        if (string != null) {
            stringBuffer.append(FILE_SEPARATOR).append(string);
        } else {
            String string4 = httpServletRequest.getRequestURI();
            if (string4.charAt(0) != FILE_SEPARATOR_CHAR) {
                stringBuffer.append(FILE_SEPARATOR_CHAR);
            }
            stringBuffer.append(string4);
            stringBuffer.append("_").append(httpServletRequest.getMethod()).append("_");
            string4 = this.getSortedQueryString(httpServletRequest);
            if (string4 != null) {
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                    byte[] byArray = messageDigest.digest(string4.getBytes());
                    stringBuffer.append("_");
                    stringBuffer.append(ServletCacheAdministrator.toBase64(byArray).replace('/', '_'));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    protected String getSortedQueryString(HttpServletRequest httpServletRequest) {
        Map map = httpServletRequest.getParameterMap();
        if (map.isEmpty()) {
            return null;
        }
        Set set = new TreeMap(map).entrySet();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String[] stringArray = (String[])entry.getValue();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = (String)entry.getKey();
                if (string.length() == 10 && "jsessionid".equals(string)) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append('&');
                }
                stringBuffer.append(string).append('=').append(stringArray[i]);
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public void logError(String string) {
        log.error((Object)("[oscache]: " + string));
    }

    public void putInCache(int n, HttpServletRequest httpServletRequest, String string, Object object) {
        this.putInCache(n, httpServletRequest, string, object, null);
    }

    public void putInCache(int n, HttpServletRequest httpServletRequest, String string, Object object, EntryRefreshPolicy entryRefreshPolicy) {
        Cache cache = this.getCache(httpServletRequest, n);
        string = this.generateEntryKey(string, httpServletRequest, n);
        cache.putInCache(string, object, entryRefreshPolicy);
    }

    public void setCacheCapacity(int n, HttpServletRequest httpServletRequest, int n2) {
        this.setCacheCapacity(n2);
        this.getCache(httpServletRequest, n).setCapacity(n2);
    }

    public void removeScopeEventListener(ScopeEventListener scopeEventListener) {
        this.listenerList.remove(class$com$opensymphony$oscache$base$events$ScopeEventListener == null ? (class$com$opensymphony$oscache$base$events$ScopeEventListener = ServletCacheAdministrator.class$("com.opensymphony.oscache.base.events.ScopeEventListener")) : class$com$opensymphony$oscache$base$events$ScopeEventListener, scopeEventListener);
    }

    protected void finalizeListeners(Cache cache) {
        super.finalizeListeners(cache);
    }

    private static String toBase64(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; i += 3) {
            boolean bl = i + 1 < n;
            boolean bl2 = i + 2 < n;
            int n2 = byArray[i] & 0xFF;
            int n3 = bl ? byArray[i + 1] & 0xFF : 0;
            int n4 = bl2 ? byArray[i + 2] & 0xFF : 0;
            stringBuffer.append(m_strBase64Chars.charAt(n2 / 4));
            stringBuffer.append(m_strBase64Chars.charAt(n3 / 16 + (n2 & 3) * 16));
            stringBuffer.append(bl ? m_strBase64Chars.charAt(n4 / 64 + (n3 & 0xF) * 4) : (char)'=');
            stringBuffer.append(bl2 ? m_strBase64Chars.charAt(n4 & 0x3F) : (char)'=');
        }
        return stringBuffer.toString();
    }

    private ServletCache createCache(int n, String string) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Created new cache in scope " + n));
        }
        ServletCache servletCache = new ServletCache(this, this.algorithmClass, this.cacheCapacity, n);
        this.config.set(HASH_KEY_SCOPE, "" + n);
        this.config.set(HASH_KEY_SESSION_ID, string);
        servletCache = (ServletCache)this.configureStandardListeners(servletCache);
        if (this.config.getProperty("cache.event.listeners") != null) {
            CacheEventListener[] cacheEventListenerArray = this.getCacheEventListeners();
            for (int i = 0; i < cacheEventListenerArray.length; ++i) {
                if (!(cacheEventListenerArray[i] instanceof ScopeEventListener)) continue;
                servletCache.addCacheEventListener(cacheEventListenerArray[i], class$com$opensymphony$oscache$base$events$ScopeEventListener == null ? ServletCacheAdministrator.class$("com.opensymphony.oscache.base.events.ScopeEventListener") : class$com$opensymphony$oscache$base$events$ScopeEventListener);
            }
        }
        return servletCache;
    }

    private void dispatchScopeEvent(ScopeEventType scopeEventType, int n, Date date, String string) {
        ScopeEvent scopeEvent = new ScopeEvent(scopeEventType, n, date, string);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$opensymphony$oscache$base$events$ScopeEventListener == null ? ServletCacheAdministrator.class$("com.opensymphony.oscache.base.events.ScopeEventListener") : class$com$opensymphony$oscache$base$events$ScopeEventListener)) continue;
            ((ScopeEventListener)objectArray[i + 1]).scopeFlushed(scopeEvent);
        }
    }

    private void initHostDomainInKey() {
        String string = this.getProperty(CACHE_USE_HOST_DOMAIN_KEY);
        this.useHostDomainInKey = "true".equalsIgnoreCase(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

