/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.util;

import com.opensymphony.oscache.util.ValueSet;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;

public class FastCronParser {
    private static final int NUMBER_OF_CRON_FIELDS = 5;
    private static final int MINUTE = 0;
    private static final int HOUR = 1;
    private static final int DAY_OF_MONTH = 2;
    private static final int MONTH = 3;
    private static final int DAY_OF_WEEK = 4;
    private static final int[] MIN_VALUE = new int[]{0, 0, 1, 1, 0};
    private static final int[] MAX_VALUE = new int[]{59, 23, 31, 12, 6};
    private static final int[] DAYS_IN_MONTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private String cronExpression = null;
    private long[] lookup = new long[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE};
    private int[] lookupMax = new int[]{-1, -1, -1, -1, -1};
    private int[] lookupMin = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};

    public FastCronParser() {
    }

    public FastCronParser(String string) throws ParseException {
        this.setCronExpression(string);
    }

    public void setCronExpression(String string) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException("Cron time expression cannot be null");
        }
        this.cronExpression = string;
        this.parseExpression(string);
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public boolean hasMoreRecentMatch(long l) {
        return l < this.getTimeBefore(System.currentTimeMillis());
    }

    public long getTimeBefore(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(l));
        int n = gregorianCalendar.get(12);
        int n2 = gregorianCalendar.get(11);
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(2) + 1;
        int n5 = gregorianCalendar.get(1);
        long l2 = this.lookup[0];
        long l3 = this.lookup[1];
        long l4 = this.lookup[2];
        long l5 = this.lookup[3];
        long l6 = this.lookup[4];
        boolean bl = l4 != Long.MAX_VALUE;
        boolean bl2 = l6 != Long.MAX_VALUE;
        while (true) {
            int n6;
            int n7;
            int n8;
            int n9;
            boolean bl3 = false;
            if (n4 < 1) {
                n4 += 12;
                --n5;
            }
            boolean bl4 = false;
            if (l5 != Long.MAX_VALUE) {
                for (n9 = n4 + 11; n9 > n4 - 1; --n9) {
                    n8 = n9 % 12 + 1;
                    n7 = this.numberOfDaysInMonth(n8, n5);
                    if ((1L << n8 - 1 & l5) == 0L) continue;
                    if (n8 > n4) {
                        --n5;
                    }
                    if (bl && n7 < this.lookupMin[2]) continue;
                    if (n4 != n8) {
                        n3 = n7 <= this.lookupMax[2] ? n7 : this.lookupMax[2];
                        n2 = this.lookupMax[1];
                        n = this.lookupMax[0];
                    }
                    n4 = n8;
                    bl4 = true;
                    break;
                }
                if (!bl4) {
                    --n5;
                    continue;
                }
            }
            if (n3 < 1) {
                n3 += this.numberOfDaysInMonth(--n4, n5);
                n2 = this.lookupMax[1];
                continue;
            }
            if (bl && !bl2) {
                n9 = this.numberOfDaysInMonth(n4, n5);
                n8 = this.numberOfDaysInMonth(n4 - 1, n5);
                for (n7 = n3 + 30; n7 > n3 - 1; --n7) {
                    n6 = n7 % 31 + 1;
                    if (n6 <= n3 && n6 > n9 || n6 > n3 && n6 > n8 || (1L << n6 - 1 & l4) == 0L) continue;
                    if (n6 > n3) {
                        --n4;
                        bl3 = true;
                    }
                    if (n3 != n6) {
                        n2 = this.lookupMax[1];
                        n = this.lookupMax[0];
                    }
                    n3 = n6;
                    break;
                }
                if (bl3) {
                    continue;
                }
            } else if (bl2 && !bl) {
                n9 = 0;
                n8 = this.dayOfWeek(n3, n4, n5);
                for (n7 = n8 + 7; n7 > n8; --n7) {
                    n6 = n7 % 7;
                    if ((1L << n6 & l6) != 0L) {
                        if ((n3 -= n9) < 1) {
                            n3 += this.numberOfDaysInMonth(--n4, n5);
                            bl3 = true;
                        }
                        if (n8 == n6) break;
                        n2 = this.lookupMax[1];
                        n = this.lookupMax[0];
                        break;
                    }
                    ++n9;
                }
                if (bl3) continue;
            }
            if (n2 < 0) {
                n2 += 24;
                --n3;
                continue;
            }
            if (l3 != Long.MAX_VALUE) {
                for (n9 = n2 + 24; n9 > n2; --n9) {
                    n8 = n9 % 24;
                    if ((1L << n8 & l3) == 0L) continue;
                    if (n8 > n2) {
                        --n3;
                        bl3 = true;
                    }
                    if (n2 != n8) {
                        n = this.lookupMax[0];
                    }
                    n2 = n8;
                    break;
                }
                if (bl3) continue;
            }
            if (l2 == Long.MAX_VALUE) break;
            for (n9 = n + 60; n9 > n; --n9) {
                n8 = n9 % 60;
                if ((1L << n8 & l2) == 0L) continue;
                if (n8 > n) {
                    --n2;
                    bl3 = true;
                }
                n = n8;
                break;
            }
            if (!bl3) break;
        }
        gregorianCalendar.set(1, n5);
        gregorianCalendar.set(2, n4 - 1);
        gregorianCalendar.set(5, n3);
        gregorianCalendar.set(11, n2);
        gregorianCalendar.set(12, n);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTime().getTime();
    }

    private void parseExpression(String string) throws ParseException {
        try {
            int n;
            int n2;
            int n3 = 0;
            while (n3 < this.lookup.length) {
                this.lookupMin[n3] = Integer.MAX_VALUE;
                this.lookupMax[n3] = -1;
                this.lookup[n3++] = 0L;
            }
            char[][] cArrayArray = new char[5][];
            int n4 = string.length();
            char[] cArray = new char[n4];
            string.getChars(0, n4, cArray, 0);
            int n5 = 0;
            int n6 = 0;
            boolean bl = true;
            for (n2 = 0; n2 < n4 && n5 < 5; ++n2) {
                int n7 = n = cArray[n2] != ' ' && cArray[n2] != '\t' ? 1 : 0;
                if (n != 0 && bl) {
                    n6 = n2;
                    bl = false;
                }
                if (n2 == n4 - 1) {
                    ++n2;
                }
                if ((n != 0 || bl) && n2 != n4) continue;
                cArrayArray[n5] = new char[n2 - n6];
                System.arraycopy(cArray, n6, cArrayArray[n5], 0, n2 - n6);
                bl = true;
                ++n5;
            }
            if (n5 < 5) {
                throw new ParseException("Unexpected end of expression while parsing \"" + string + "\". Cron expressions require 5 separate fields.", n4);
            }
            for (n5 = 0; n5 < 5; ++n5) {
                n6 = 0;
                n2 = 1;
                n = cArrayArray[n5].length;
                for (int i = 0; i < n; ++i) {
                    boolean bl2;
                    boolean bl3 = bl2 = cArrayArray[n5][i] != ',';
                    if (bl2 && n2 != 0) {
                        n6 = i;
                        n2 = 0;
                    }
                    if (i == n - 1) {
                        ++i;
                    }
                    if ((bl2 || n2 != 0) && i != n) continue;
                    char[] cArray2 = new char[i - n6];
                    System.arraycopy(cArrayArray[n5], n6, cArray2, 0, i - n6);
                    this.storeExpressionValues(cArray2, n5);
                    n2 = 1;
                }
                if (this.lookup[n5] != 0L) continue;
                throw new ParseException("Token " + new String(cArrayArray[n5]) + " contains no valid entries for this field.", 0);
            }
            switch (this.lookupMin[2]) {
                case 31: {
                    this.lookup[3] = this.lookup[3] & 0xAD7L;
                }
                case 30: {
                    this.lookup[3] = this.lookup[3] & 0xFFDL;
                    if (this.lookup[3] != 0L) break;
                    throw new ParseException("The cron expression \"" + string + "\" will never match any months - the day of month field is out of range.", 0);
                }
            }
            if (this.lookup[2] != Long.MAX_VALUE && this.lookup[4] != Long.MAX_VALUE) {
                throw new ParseException("The cron expression \"" + string + "\" is invalid. Having both a day-of-month and day-of-week field is not supported.", 0);
            }
        }
        catch (Exception exception) {
            if (exception instanceof ParseException) {
                throw (ParseException)exception;
            }
            throw new ParseException("Illegal cron expression format (" + exception.toString() + ")", 0);
        }
    }

    private void storeExpressionValues(char[] cArray, int n) throws ParseException {
        int n2 = 0;
        int n3 = -99;
        int n4 = -99;
        int n5 = -1;
        boolean bl = true;
        boolean bl2 = false;
        while (n5 < 0 && n2 < cArray.length) {
            char c = cArray[n2++];
            if (n2 == 1 && c == '*') {
                if (n2 >= cArray.length) {
                    this.addToLookup(-1, -1, n, 1);
                    return;
                }
                n3 = -1;
                n4 = -1;
                bl = false;
                continue;
            }
            if (bl) {
                if (c >= '0' && c <= '9') {
                    ValueSet valueSet = this.getValue(c - 48, cArray, n2);
                    if (n3 == -99) {
                        n3 = valueSet.value;
                    } else if (!bl2) {
                        n4 = valueSet.value;
                    } else {
                        if (n4 == -99) {
                            n4 = MAX_VALUE[n];
                        }
                        n5 = valueSet.value;
                    }
                    n2 = valueSet.pos;
                    bl = false;
                    continue;
                }
                if (!bl2 && n4 == -99) {
                    if (n == 3) {
                        int n6;
                        if (n3 == -99) {
                            n3 = this.getMonthVal(c, cArray, n2++);
                        } else {
                            n4 = this.getMonthVal(c, cArray, n2++);
                        }
                        bl = false;
                        while (++n2 < cArray.length && (n6 = cArray[n2] | 0x20) >= 97 && n6 <= 122) {
                        }
                        continue;
                    }
                    if (n == 4) {
                        int n7;
                        if (n3 == -99) {
                            n3 = this.getDayOfWeekVal(c, cArray, n2++);
                        } else {
                            n4 = this.getDayOfWeekVal(c, cArray, n2++);
                        }
                        bl = false;
                        while (++n2 < cArray.length && (n7 = cArray[n2] | 0x20) >= 97 && n7 <= 122) {
                        }
                        continue;
                    }
                }
            } else {
                if (c == '-' && n3 != -99 && n4 == -99) {
                    bl = true;
                    continue;
                }
                if (c == '/' && n3 != -99) {
                    bl = true;
                    bl2 = true;
                    continue;
                }
            }
            throw this.makeParseException("Invalid character encountered while parsing element", cArray, n2);
        }
        if (cArray.length > n2) {
            throw this.makeParseException("Extraneous characters found while parsing element", cArray, n2);
        }
        if (n4 == -99) {
            n4 = n3;
        }
        if (n5 < 0) {
            n5 = 1;
        }
        this.addToLookup(n3, n4, n, n5);
    }

    private ValueSet getValue(int n, char[] cArray, int n2) {
        ValueSet valueSet = new ValueSet();
        valueSet.value = n;
        if (n2 >= cArray.length) {
            valueSet.pos = n2;
            return valueSet;
        }
        char c = cArray[n2];
        while (c >= '0' && c <= '9') {
            valueSet.value = valueSet.value * 10 + (c - 48);
            if (++n2 >= cArray.length) break;
            c = cArray[n2];
        }
        valueSet.pos = n2;
        return valueSet;
    }

    private void addToLookup(int n, int n2, int n3, int n4) throws ParseException {
        if (n == n2) {
            if (n < 0) {
                n = this.lookupMin[n3] = MIN_VALUE[n3];
                n2 = this.lookupMax[n3] = MAX_VALUE[n3];
                if (n4 <= 1) {
                    this.lookup[n3] = Long.MAX_VALUE;
                    return;
                }
            } else {
                if (n < MIN_VALUE[n3]) {
                    throw new ParseException("Value " + n + " in field " + n3 + " is lower than the minimum allowable value for this field (min=" + MIN_VALUE[n3] + ")", 0);
                }
                if (n > MAX_VALUE[n3]) {
                    throw new ParseException("Value " + n + " in field " + n3 + " is higher than the maximum allowable value for this field (max=" + MAX_VALUE[n3] + ")", 0);
                }
            }
        } else {
            if (n > n2) {
                n2 ^= n;
                n ^= n2;
                n2 ^= n;
            }
            if (n < 0) {
                n = MIN_VALUE[n3];
            } else if (n < MIN_VALUE[n3]) {
                throw new ParseException("Value " + n + " in field " + n3 + " is lower than the minimum allowable value for this field (min=" + MIN_VALUE[n3] + ")", 0);
            }
            if (n2 < 0) {
                n2 = MAX_VALUE[n3];
            } else if (n2 > MAX_VALUE[n3]) {
                throw new ParseException("Value " + n2 + " in field " + n3 + " is higher than the maximum allowable value for this field (max=" + MAX_VALUE[n3] + ")", 0);
            }
        }
        if (n4 < 1) {
            n4 = 1;
        }
        int n5 = n - MIN_VALUE[n3];
        for (n5 = n - MIN_VALUE[n3]; n5 <= n2 - MIN_VALUE[n3]; n5 += n4) {
            int n6 = n3;
            this.lookup[n6] = this.lookup[n6] | 1L << n5;
        }
        if (this.lookupMin[n3] > n) {
            this.lookupMin[n3] = n;
        }
        if (this.lookupMax[n3] < (n5 += MIN_VALUE[n3] - n4)) {
            this.lookupMax[n3] = n5;
        }
    }

    private boolean isLeapYear(int n) {
        return n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
    }

    private int dayOfWeek(int n, int n2, int n3) {
        int n4;
        if (n2 < 3) {
            int n5 = n3;
            n4 = n5;
            n3 = n5 - 1;
        } else {
            n4 = n3 - 2;
        }
        return (23 * n2 / 9 + (n += n4) + 4 + n3 / 4 - n3 / 100 + n3 / 400) % 7;
    }

    private int numberOfDaysInMonth(int n, int n2) {
        while (n < 1) {
            n += 12;
            --n2;
        }
        while (n > 12) {
            n -= 12;
            ++n2;
        }
        if (n == 2) {
            return this.isLeapYear(n2) ? 29 : 28;
        }
        return DAYS_IN_MONTH[n - 1];
    }

    private int getDayOfWeekVal(char c, char[] cArray, int n) throws ParseException {
        if (n + 1 >= cArray.length) {
            throw this.makeParseException("Unexpected end of element encountered while parsing a day name", cArray, n);
        }
        int n2 = cArray[n] | 0x20;
        int n3 = cArray[n + 1] | 0x20;
        switch (c | 0x20) {
            case 115: {
                if (n2 == 117 && n3 == 110) {
                    return 0;
                }
                if (n2 != 97 || n3 != 116) break;
                return 6;
            }
            case 109: {
                if (n2 != 111 || n3 != 110) break;
                return 1;
            }
            case 116: {
                if (n2 == 117 && n3 == 101) {
                    return 2;
                }
                if (n2 != 104 || n3 != 117) break;
                return 4;
            }
            case 119: {
                if (n2 != 101 || n3 != 100) break;
                return 3;
            }
            case 102: {
                if (n2 != 114 || n3 != 105) break;
                return 5;
            }
        }
        throw this.makeParseException("Unexpected character while parsing a day name", cArray, n - 1);
    }

    private int getMonthVal(char c, char[] cArray, int n) throws ParseException {
        if (n + 1 >= cArray.length) {
            throw this.makeParseException("Unexpected end of element encountered while parsing a month name", cArray, n);
        }
        int n2 = cArray[n] | 0x20;
        int n3 = cArray[n + 1] | 0x20;
        switch (c | 0x20) {
            case 106: {
                if (n2 == 97 && n3 == 110) {
                    return 1;
                }
                if (n2 != 117) break;
                if (n3 == 110) {
                    return 6;
                }
                if (n3 != 108) break;
                return 7;
            }
            case 102: {
                if (n2 != 101 || n3 != 98) break;
                return 2;
            }
            case 109: {
                if (n2 != 97) break;
                if (n3 == 114) {
                    return 3;
                }
                if (n3 != 121) break;
                return 5;
            }
            case 97: {
                if (n2 == 112 && n3 == 114) {
                    return 4;
                }
                if (n2 != 117 || n3 != 103) break;
                return 8;
            }
            case 115: {
                if (n2 != 101 || n3 != 112) break;
                return 9;
            }
            case 111: {
                if (n2 != 99 || n3 != 116) break;
                return 10;
            }
            case 110: {
                if (n2 != 111 || n3 != 118) break;
                return 11;
            }
            case 100: {
                if (n2 != 101 || n3 != 99) break;
                return 12;
            }
        }
        throw this.makeParseException("Unexpected character while parsing a month name", cArray, n - 1);
    }

    public String getExpressionSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getExpressionSetSummary(0)).append(' ');
        stringBuffer.append(this.getExpressionSetSummary(1)).append(' ');
        stringBuffer.append(this.getExpressionSetSummary(2)).append(' ');
        stringBuffer.append(this.getExpressionSetSummary(3)).append(' ');
        stringBuffer.append(this.getExpressionSetSummary(4));
        return stringBuffer.toString();
    }

    private String getExpressionSetSummary(int n) {
        if (this.lookup[n] == Long.MAX_VALUE) {
            return "*";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = MIN_VALUE[n]; i <= MAX_VALUE[n]; ++i) {
            if ((this.lookup[n] & 1L << i - MIN_VALUE[n]) == 0L) continue;
            if (!bl) {
                stringBuffer.append(",");
            } else {
                bl = false;
            }
            stringBuffer.append(String.valueOf(i));
        }
        return stringBuffer.toString();
    }

    private ParseException makeParseException(String string, char[] cArray, int n) {
        char[] cArray2 = new char[string.length() + cArray.length + 3];
        int n2 = string.length();
        System.arraycopy(string.toCharArray(), 0, cArray2, 0, n2);
        cArray2[n2] = 32;
        cArray2[n2 + 1] = 91;
        System.arraycopy(cArray, 0, cArray2, n2 + 2, cArray.length);
        cArray2[cArray2.length - 1] = 93;
        return new ParseException(new String(cArray2), n);
    }
}

